/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.util.CargoException;
import org.ietf.jgss.GSSException;

public class EmbeddedContainerClasspathResolver {
    private static final Map<String, List<String>> DEPENDENCIES = new HashMap<String, List<String>>();

    protected List<String> getDependencies(String containerId) {
        return DEPENDENCIES.get(containerId);
    }

    public ClassLoader resolveDependencies(String containerId, String containerHome) throws FileNotFoundException {
        List<String> dependencies = this.getDependencies(containerId);
        if (dependencies == null) {
            return null;
        }
        URLClassLoader classloader = null;
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String dependencyRelativePath : dependencies) {
                if (dependencyRelativePath.endsWith("*.jar")) {
                    String[] dependencyRelativeSubPaths;
                    boolean found = false;
                    String folders = "";
                    for (String dependencyRelativeSubPath : dependencyRelativeSubPaths = dependencyRelativePath.split("\\|")) {
                        if (!dependencyRelativeSubPath.endsWith("*.jar")) {
                            throw new IllegalArgumentException("Dependency paths with alternatives can only be used for many folder / folder alternatives; i.e. all need to end with *.jar");
                        }
                        File folder = new File(containerHome, dependencyRelativeSubPath.substring(0, dependencyRelativeSubPath.lastIndexOf("/")));
                        File[] jars = folder.listFiles((dir, name) -> name.endsWith(".jar"));
                        if (jars != null) {
                            for (File jar : jars) {
                                if (jar.getName().startsWith("demo-") || jar.getName().startsWith("jetty-jaspi-")) continue;
                                String dependencyEndPath = dependencyRelativeSubPath.substring(dependencyRelativeSubPath.lastIndexOf("/") + 1);
                                if (!"*.jar".equals(dependencyEndPath)) {
                                    dependencyEndPath = dependencyEndPath.substring(0, dependencyEndPath.length() - 5);
                                    if (!jar.getName().startsWith(dependencyEndPath)) continue;
                                }
                                urls.add(jar.toURI().toURL());
                                found = true;
                            }
                        }
                        if (!folders.isEmpty()) {
                            folders = folders + ", ";
                        }
                        folders = folders + folder.toString();
                    }
                    if (found) continue;
                    throw new FileNotFoundException("No files matching [" + dependencyRelativePath + "] in folders: " + folders);
                }
                File dependencyPath = new File(containerHome, dependencyRelativePath);
                if (!dependencyPath.isFile()) {
                    throw new FileNotFoundException(dependencyPath.toString());
                }
                urls.add(dependencyPath.toURI().toURL());
            }
            if (!JdkUtils.isOSX() && JdkUtils.getMajorJavaVersion() < 9) {
                urls.add(JdkUtils.getToolsJar().toURI().toURL());
            }
            classloader = new URLClassLoader(urls.toArray(new URL[urls.size()]), GSSException.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to resolve dependency", (Throwable)e);
        }
        return classloader;
    }

    static {
        ArrayList<String> jetty5xDependencies = new ArrayList<String>();
        jetty5xDependencies.add("lib/*.jar");
        jetty5xDependencies.add("ext/*.jar");
        ArrayList<String> jetty6xDependencies = new ArrayList<String>();
        jetty6xDependencies.add("lib/*.jar");
        jetty6xDependencies.add("lib/jsp-2.0/*.jar");
        jetty6xDependencies.add("lib/management/*.jar");
        jetty6xDependencies.add("lib/naming/*.jar");
        jetty6xDependencies.add("lib/plus/*.jar");
        jetty6xDependencies.add("lib/xbean/*.jar");
        ArrayList<String> jetty7xDependencies = new ArrayList<String>();
        jetty7xDependencies.add("lib/*.jar");
        jetty7xDependencies.add("lib/jndi/*.jar");
        jetty7xDependencies.add("lib/jsp/*.jar");
        ArrayList<String> jetty8xDependencies = new ArrayList<String>();
        jetty8xDependencies.add("lib/*.jar");
        jetty8xDependencies.add("lib/annotations/*.jar");
        jetty8xDependencies.add("lib/jndi/*.jar");
        jetty8xDependencies.add("lib/jsp/*.jar");
        ArrayList<String> jetty9xDependencies = new ArrayList<String>();
        jetty9xDependencies.add("lib/jetty-*.jar");
        jetty9xDependencies.add("lib/servlet-api-*.jar");
        jetty9xDependencies.add("lib/annotations/*.jar|lib/jndi/*.jar");
        jetty9xDependencies.add("lib/jsp/*.jar|lib/apache-jsp/*.jar");
        ArrayList<String> jetty10x11xDependencies = new ArrayList<String>();
        jetty10x11xDependencies.add("lib/*.jar");
        jetty10x11xDependencies.add("lib/annotations/*.jar");
        jetty10x11xDependencies.add("lib/apache-jsp/*.jar");
        jetty10x11xDependencies.add("lib/logging/*.jar");
        ArrayList<String> jetty12xDependencies = new ArrayList<String>();
        jetty12xDependencies.add("lib/logging/slf4j-api-*.jar");
        jetty12xDependencies.add("lib/logging/jetty-slf4j-impl-*.jar");
        jetty12xDependencies.add("lib/jetty-http-*.jar");
        jetty12xDependencies.add("lib/jetty-server-*.jar");
        jetty12xDependencies.add("lib/jetty-xml-*.jar");
        jetty12xDependencies.add("lib/jetty-util-*.jar");
        jetty12xDependencies.add("lib/jetty-io-*.jar");
        jetty12xDependencies.add("lib/jetty-session-*.jar");
        jetty12xDependencies.add("lib/jakarta.servlet-api-6.*.jar");
        jetty12xDependencies.add("lib/jetty-ee10-servlet-*.jar");
        jetty12xDependencies.add("lib/jetty-jndi-*.jar");
        jetty12xDependencies.add("lib/jetty-plus-*.jar");
        jetty12xDependencies.add("lib/jetty-security-*.jar");
        jetty12xDependencies.add("lib/jetty-ee-*.jar");
        jetty12xDependencies.add("lib/jetty-ee10-webapp-*.jar");
        jetty12xDependencies.add("lib/jetty-ee10-plus-*.jar");
        jetty12xDependencies.add("lib/jakarta.transaction-api-2.*.jar");
        jetty12xDependencies.add("lib/jakarta.interceptor-api-2.*.jar");
        jetty12xDependencies.add("lib/jakarta.enterprise.cdi-api-4.*.jar");
        jetty12xDependencies.add("lib/jakarta.inject-api-2.*.jar");
        jetty12xDependencies.add("lib/jakarta.enterprise.lang-model-4.*.jar");
        jetty12xDependencies.add("lib/jetty-ee10-annotations-*.jar");
        jetty12xDependencies.add("lib/ee10-annotations/*.jar");
        jetty12xDependencies.add("lib/jetty-ee10-apache-jsp-*.jar");
        jetty12xDependencies.add("lib/ee10-apache-jsp/*.jar");
        ArrayList<String> tomcat5xDependencies = new ArrayList<String>();
        tomcat5xDependencies.add("bin/*.jar");
        tomcat5xDependencies.add("common/lib/*.jar");
        tomcat5xDependencies.add("server/lib/*.jar");
        ArrayList<String> tomcat6x7x8x9x10x11xDependencies = new ArrayList<String>();
        tomcat6x7x8x9x10x11xDependencies.add("bin/*.jar");
        tomcat6x7x8x9x10x11xDependencies.add("lib/*.jar");
        DEPENDENCIES.put("jetty5x", jetty5xDependencies);
        DEPENDENCIES.put("jetty6x", jetty6xDependencies);
        DEPENDENCIES.put("jetty7x", jetty7xDependencies);
        DEPENDENCIES.put("jetty8x", jetty8xDependencies);
        DEPENDENCIES.put("jetty9x", jetty9xDependencies);
        DEPENDENCIES.put("jetty10x", jetty10x11xDependencies);
        DEPENDENCIES.put("jetty11x", jetty10x11xDependencies);
        DEPENDENCIES.put("jetty12x", jetty12xDependencies);
        DEPENDENCIES.put("tomcat5x", tomcat5xDependencies);
        DEPENDENCIES.put("tomcat6x", tomcat6x7x8x9x10x11xDependencies);
        DEPENDENCIES.put("tomcat7x", tomcat6x7x8x9x10x11xDependencies);
        DEPENDENCIES.put("tomcat8x", tomcat6x7x8x9x10x11xDependencies);
        DEPENDENCIES.put("tomcat9x", tomcat6x7x8x9x10x11xDependencies);
        DEPENDENCIES.put("tomcat10x", tomcat6x7x8x9x10x11xDependencies);
        DEPENDENCIES.put("tomcat11x", tomcat6x7x8x9x10x11xDependencies);
    }
}

