/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.installer.Proxy;

public class EnvironmentTestData {
    public static List<String> jakartaEeContainers;
    public String containerId;
    public ContainerType containerType;
    public URL installURL;
    public String downloadDir;
    public String extractDir;
    public int port;
    public int rmiPort;
    public long containerTimeout;
    public String configurationHome;
    public String containerHome;
    public String javaHome;
    public Proxy proxy;
    public Map<String, String> testDataArtifacts = new HashMap<String, String>();

    public EnvironmentTestData(String containerId, ContainerType containerType, String targetDirSuffix) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.configurationHome = new File(this.getFileFromString(this.getSystemProperty("cargo.target.dir")), targetDirSuffix).getPath();
        this.downloadDir = this.getSystemProperty("cargo.download.dir");
        this.extractDir = new File(this.getFileFromString(this.getSystemProperty("cargo.target.dir")), "cargo/container").getPath();
        this.proxy = this.createProxyElement();
        this.installURL = this.createInstallURL(containerId);
        this.port = this.createPort(containerId, "servlet", 8080);
        this.rmiPort = this.createPort(containerId, "rmi", 1099);
        this.containerHome = this.getSystemProperty("cargo." + containerId + ".home");
        this.javaHome = this.getSystemProperty("cargo." + containerId + ".java.home");
        this.containerTimeout = Long.parseLong(this.getSystemProperty("cargo.containers.timeout", "60000"));
        String deployablesLocation = System.getProperty("cargo.testdata.deployables");
        if (deployablesLocation == null) {
            throw new ContainerException("Property cargo.testdata.deployables not set");
        }
        File deployables = new File(deployablesLocation);
        if (!deployables.isDirectory()) {
            throw new ContainerException("Property cargo.testdata.deployables does not point to a directory: " + deployables);
        }
        if (jakartaEeContainers.contains(containerId)) {
            File convertedDeployables = new File(deployables.getParentFile(), "deployables-jakarta-ee");
            if (!convertedDeployables.isDirectory()) {
                File jakartaEeMigratorFile = new File(System.getProperty("cargo.testdata.test-jars"), "jakartaee-migration-tool.jar");
                if (!jakartaEeMigratorFile.isFile()) {
                    throw new IllegalArgumentException("Cannot find the Jakarta EE converter " + jakartaEeMigratorFile);
                }
                try {
                    URL[] jakartaEeMigratorUrl = new URL[]{jakartaEeMigratorFile.toURI().toURL()};
                    try (URLClassLoader jakartaEeMigratorClassLoader = new URLClassLoader(jakartaEeMigratorUrl);){
                        Class<?> jakartaEeMigratorClass = jakartaEeMigratorClassLoader.loadClass("org.apache.tomcat.jakartaee.Migration");
                        Object jakartaEeMigrator = jakartaEeMigratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        Class<?> eeSpecProfileClass = jakartaEeMigratorClassLoader.loadClass("org.apache.tomcat.jakartaee.EESpecProfile");
                        Method setEESpecProfile = jakartaEeMigratorClass.getMethod("setEESpecProfile", eeSpecProfileClass);
                        Class<?> eeSpecProfilesClass = jakartaEeMigratorClassLoader.loadClass("org.apache.tomcat.jakartaee.EESpecProfiles");
                        Object eeSpecProfile = eeSpecProfilesClass.getField("EE").get(null);
                        setEESpecProfile.invoke(jakartaEeMigrator, eeSpecProfile);
                        Method setSource = jakartaEeMigratorClass.getMethod("setSource", File.class);
                        Method setDestination = jakartaEeMigratorClass.getMethod("setDestination", File.class);
                        Method execute = jakartaEeMigratorClass.getMethod("execute", new Class[0]);
                        convertedDeployables.mkdir();
                        for (File deployable : deployables.listFiles()) {
                            setSource.invoke(jakartaEeMigrator, deployable);
                            setDestination.invoke(jakartaEeMigrator, new File(convertedDeployables, deployable.getName()));
                            execute.invoke(jakartaEeMigrator, new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot convert deployable to Jakarta EE", e);
                }
            }
            deployablesLocation = convertedDeployables.getAbsolutePath();
            deployables = convertedDeployables;
        }
        for (File deployable : deployables.listFiles()) {
            if (!deployable.isFile()) continue;
            String name = deployable.getName();
            if (name.contains(".")) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            this.testDataArtifacts.put(name, deployable.getAbsolutePath());
        }
    }

    private int createPort(String containerId, String type, int defaultValue) {
        String portString = this.getSystemProperty("cargo.samples." + containerId + "." + type + ".port");
        if (portString == null) {
            portString = this.getSystemProperty("cargo.samples." + type + ".port");
        }
        if (portString == null) {
            return defaultValue;
        }
        return Integer.parseInt(portString);
    }

    private URL createInstallURL(String containerName) {
        URL installURL = null;
        String url = this.getSystemProperty("cargo." + containerName + ".url");
        if (url != null) {
            try {
                installURL = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new ContainerException("invalid install URL [" + url + "]", (Throwable)e);
            }
        }
        return installURL;
    }

    private String getSystemProperty(String name) {
        String result = System.getProperty(name);
        if (result == null || result.isEmpty()) {
            result = null;
        }
        return result;
    }

    private String getSystemProperty(String name, String defaultValue) {
        String result = System.getProperty(name);
        return result == null || result.isEmpty() ? defaultValue : result;
    }

    private File getFileFromString(String fileName) {
        File result = null;
        if (fileName != null) {
            result = new File(fileName);
        }
        return result;
    }

    private Proxy createProxyElement() {
        String proxyHost = this.getSystemProperty("cargo.proxy.host");
        String proxyPort = this.getSystemProperty("cargo.proxy.port", "80");
        String proxyUser = this.getSystemProperty("cargo.proxy.user");
        String proxyPassword = System.getProperty("cargo.proxy.password");
        String proxyExcludeHosts = this.getSystemProperty("cargo.proxy.excludehosts", "");
        Proxy proxy = null;
        if (proxyHost != null) {
            proxy = new Proxy();
            proxy.setHost(proxyHost);
            proxy.setPort(Integer.parseInt(proxyPort));
            if (proxyUser != null) {
                proxy.setUser(proxyUser);
                proxy.setPassword(proxyPassword);
            }
            proxy.setExcludeHosts(proxyExcludeHosts);
        }
        return proxy;
    }

    public String getTestDataFileFor(String artifactName) {
        String result = this.testDataArtifacts.get(artifactName);
        if (result == null) {
            throw new ContainerException("Test data artifact not found [" + artifactName + "]");
        }
        return result;
    }

    static {
        int payaraMajorVersion;
        jakartaEeContainers = Arrays.asList("jetty11x", "jetty12x", "glassfish6x", "glassfish7x", "glassfish8x", "tomcat10x", "tomcat11x", "tomee9x", "tomee10x", "weblogic15x", "wildfly27x", "wildfly28x", "wildfly29x", "wildfly30x", "wildfly31x", "wildfly32x", "wildfly33x", "wildfly34x", "wildfly35x", "wildfly36x", "wildfly37x", "wildfly38x");
        String payaraUrl = System.getProperty("cargo.payara.url");
        if (payaraUrl != null && (payaraMajorVersion = payaraUrl.indexOf("/payara-")) > 0) {
            String payaraVersionString = payaraUrl.substring(payaraMajorVersion + 8);
            payaraMajorVersion = Integer.parseInt(payaraVersionString = payaraVersionString.substring(0, payaraVersionString.indexOf(".")));
            if (payaraMajorVersion >= 6) {
                ArrayList<String> updatedJakartaEeContainers = new ArrayList<String>(jakartaEeContainers.size() + 1);
                updatedJakartaEeContainers.addAll(jakartaEeContainers);
                updatedJakartaEeContainers.add("payara");
                jakartaEeContainers = updatedJakartaEeContainers;
            }
        }
    }
}

