/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.net.URL;
import junit.framework.Test;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.packager.Packager;
import org.codehaus.cargo.container.packager.PackagerType;
import org.codehaus.cargo.container.spi.packager.AbstractDirectoryPackager;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.generic.packager.DefaultPackagerFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasDirectoryPackagerValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class PackagerTest
extends AbstractCargoTestCase {
    public PackagerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that can run on installed local containers supporting directory Packagers");
        suite.addTestSuite(PackagerTest.class, new Validator[]{new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasDirectoryPackagerValidator()});
        return suite;
    }

    public void testPackageContainer() throws Exception {
        StandaloneLocalConfiguration configuration = (StandaloneLocalConfiguration)this.createConfiguration(ConfigurationType.STANDALONE);
        InstalledLocalContainer container = (InstalledLocalContainer)this.createContainer((Configuration)configuration);
        Deployable war = new DefaultDeployableFactory().createDeployable(container.getId(), this.getTestData().getTestDataFileFor("simple-war"), DeployableType.WAR);
        configuration.addDeployable(war);
        configuration.configure((LocalContainer)container);
        File targetLocation = new File(new File(this.getTestData().targetDir).getParentFile(), "package");
        DefaultPackagerFactory factory = new DefaultPackagerFactory();
        Packager packager = factory.createPackager(this.getTestData().containerId, PackagerType.DIRECTORY, targetLocation.getPath());
        ((AbstractDirectoryPackager)packager).setLogger(this.getLogger());
        packager.packageContainer(container);
        InstalledLocalContainer assertContainer = (InstalledLocalContainer)new DefaultContainerFactory().createContainer(this.getTestData().containerId, this.getTestData().containerType, this.createConfiguration(ConfigurationType.EXISTING, targetLocation.getPath()));
        assertContainer.setLogger(this.getLogger());
        assertContainer.setHome(targetLocation.getPath());
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        assertContainer.start();
        PingUtils.assertPingTrue((String)"simple war not started", (URL)warPingURL, (Logger)this.getLogger());
        assertContainer.stop();
        PingUtils.assertPingFalse((String)"simple war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

