/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasLocalDeployerValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class WarAndDeployerCapabilityContainerTest
extends AbstractCargoTestCase {
    public WarAndDeployerCapabilityContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting WAR deployments using a local Deployer");
        suite.addTestSuite(WarAndDeployerCapabilityContainerTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator(), new HasLocalDeployerValidator()});
        return suite;
    }

    public void testWarHotDeployment() throws Exception {
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        WAR war = (WAR)new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-war"), DeployableType.WAR);
        war.setContext("simple");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/" + war.getContext() + "/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingFalse((String)"simple war should not be started at this point", (URL)warPingURL, (Logger)this.getLogger());
        Deployer deployer = this.createDeployer(this.getContainer());
        URLDeployableMonitor deployableMonitor = new URLDeployableMonitor(warPingURL);
        deployableMonitor.setLogger(this.getLogger());
        deployer.deploy((Deployable)war, (DeployableMonitor)deployableMonitor);
        PingUtils.assertPingTrue((String)"simple war should have been started at this point", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
    }
}

