/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jboss;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractJBossCapabilityTestCase
extends AbstractCargoTestCase {
    public AbstractJBossCapabilityTestCase(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    protected <T> T jndiLookup(String name) throws NamingException {
        try {
            URL[] urls;
            String port = this.getLocalContainer().getConfiguration().getPropertyValue("cargo.rmi.port");
            if (this.getContainer().getId().startsWith("jboss7") || this.getContainer().getId().startsWith("wildfly")) {
                ArrayList<File> files = new ArrayList<File>();
                AbstractJBossCapabilityTestCase.addAllJars(new File(this.getInstalledLocalContainer().getHome(), "modules"), files);
                urls = new URL[files.size()];
                for (int i = 0; i < files.size(); ++i) {
                    urls[i] = ((File)files.get(i)).toURI().toURL();
                }
            } else {
                File allClientJar = new File(this.getInstalledLocalContainer().getHome(), "client/jbossall-client.jar");
                if (!allClientJar.isFile()) {
                    throw new IllegalStateException("Cannot find " + allClientJar);
                }
                urls = new URL[]{allClientJar.toURI().toURL()};
            }
            URLClassLoader classloader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(classloader);
            Properties props = new Properties();
            if (this.getContainer().getId().startsWith("jboss7") || this.getContainer().getId().startsWith("wildfly")) {
                props.setProperty("java.naming.factory.initial", "org.jboss.as.naming.InitialContextFactory");
                props.setProperty("java.naming.factory.url.pkgs", "org.jboss.as.naming.interfaces");
            } else {
                props.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                props.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            }
            props.setProperty("java.naming.provider.url", "jnp://localhost:" + port);
            InitialContext jndi = new InitialContext(props);
            try {
                return (T)jndi.lookup(name);
            }
            catch (NameNotFoundException e) {
                StringBuilder sb = new StringBuilder("Cannot find " + name + ". Found names:");
                NamingEnumeration<Binding> list = jndi.listBindings("");
                while (list.hasMore()) {
                    sb.append("\n\t- " + list.next().getName());
                }
                throw new CargoException(sb.toString(), (Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Failed creating JBoss classpath", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanServerConnection createMBeanServerConnection() throws NamingException, IOException {
        String jndiName;
        String containerId = this.getContainer().getId();
        if (containerId.startsWith("jboss4")) {
            ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
            try {
                MBeanServerConnection mBeanServerConnection = (MBeanServerConnection)this.jndiLookup("jmx/invoker/RMIAdaptor");
                return mBeanServerConnection;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        }
        String username = this.getLocalContainer().getConfiguration().getPropertyValue("cargo.remote.username");
        String password = this.getLocalContainer().getConfiguration().getPropertyValue("cargo.remote.password");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (username != null && password != null) {
            String[] credentials = new String[]{username, password};
            env.put("jmx.remote.credentials", credentials);
        }
        if (containerId.startsWith("jboss5")) {
            jndiName = "jmxconnector";
        } else if (containerId.startsWith("jboss6") || containerId.startsWith("jboss7") || containerId.startsWith("wildfly")) {
            jndiName = "jmxrmi";
        } else {
            throw new UnsupportedOperationException("Method not supported for the current container: " + containerId);
        }
        String port = this.getLocalContainer().getConfiguration().getPropertyValue("cargo.jboss.jrmp.port");
        String serviceUrl = "service:jmx:rmi:///jndi/rmi://localhost:" + port + "/" + jndiName;
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        this.getLogger().debug("Creating MBeanServerConnection for service URL '" + serviceUrl + "'", ((Object)((Object)this)).getClass().getName());
        JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
        MBeanServerConnection srvCon = jmxc.getMBeanServerConnection();
        this.getLogger().debug("MBeanServerConnection created", ((Object)((Object)this)).getClass().getName());
        return srvCon;
    }

    public static void addAllJars(File folder, List<File> files) {
        if (folder.isDirectory()) {
            for (File file : folder.listFiles()) {
                if (file.isFile() && file.getName().endsWith(".jar")) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                AbstractJBossCapabilityTestCase.addAllJars(file, files);
            }
        }
    }
}

