/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.installer.Proxy;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.sample.java.EmbeddedContainerClasspathResolver;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractCargoTestCase
extends TestCase {
    private static final ContainerFactory CONTAINER_FACTORY = new DefaultContainerFactory();
    private static final ConfigurationFactory CONFIGURATION_FACTORY = new DefaultConfigurationFactory();
    private static final DeployerFactory DEPLOYER_FACTORY = new DefaultDeployerFactory();
    private Container container;
    private EnvironmentTestData testData;
    private Logger logger;
    private FileHandler fileHandler;
    private ClassLoader classLoader;

    public AbstractCargoTestCase(String testName, EnvironmentTestData testData) throws Exception {
        super(testName);
        this.testData = testData;
        File targetDir = new File(this.getTestData().targetDir);
        targetDir.mkdirs();
        if (!targetDir.isDirectory()) {
            AbstractCargoTestCase.fail((String)("Directory " + targetDir + " does not exist"));
        }
        this.logger = new FileLogger(new File(targetDir.getParentFile(), "cargo.log"), true);
        this.logger.setLevel(LogLevel.DEBUG);
        this.fileHandler = new DefaultFileHandler();
        this.fileHandler.setLogger(this.logger);
    }

    protected void setContainer(Container container) {
        this.container = container;
    }

    protected LocalContainer getLocalContainer() {
        return (LocalContainer)this.container;
    }

    protected InstalledLocalContainer getInstalledLocalContainer() {
        return (InstalledLocalContainer)this.container;
    }

    protected RemoteContainer getRemoteContainer() {
        return (RemoteContainer)this.container;
    }

    protected Container getContainer() {
        return this.container;
    }

    public Deployer createDeployer(DeployerType type, Container container) {
        Deployer deployer = DEPLOYER_FACTORY.createDeployer(container, type);
        deployer.setLogger(this.getLogger());
        return deployer;
    }

    public Deployer createDeployer(Container container) {
        Deployer deployer = DEPLOYER_FACTORY.createDeployer(container);
        deployer.setLogger(this.getLogger());
        return deployer;
    }

    public Configuration createConfiguration(ConfigurationType type) {
        return this.createConfiguration(type, this.getTestData().targetDir);
    }

    public Configuration createConfiguration(ConfigurationType type, String targetDir) {
        Configuration configuration = type != ConfigurationType.RUNTIME ? CONFIGURATION_FACTORY.createConfiguration(this.getTestData().containerId, this.getTestData().containerType, type, targetDir) : CONFIGURATION_FACTORY.createConfiguration(this.getTestData().containerId, this.getTestData().containerType, type);
        configuration.setProperty("cargo.servlet.port", "" + this.getTestData().port);
        configuration.setProperty("cargo.rmi.port", "" + this.getTestData().rmiPort);
        Properties allProperties = System.getProperties();
        for (Map.Entry<Object, Object> property : allProperties.entrySet()) {
            if (property.getKey() == null || property.getValue() == null) continue;
            String key = property.getKey().toString();
            String value = property.getValue().toString();
            String containerIdentifier = "cargo.samples." + this.getTestData().containerId;
            if (key.startsWith(containerIdentifier)) {
                key = key.replace(containerIdentifier, "cargo");
            }
            if (key.endsWith(".port")) {
                if (configuration.getProperties().get(key) == null) continue;
                configuration.setProperty(key, value);
                continue;
            }
            configuration.setProperty(key, value);
        }
        if (this.getTestData().javaHome != null && !this.getTestData().javaHome.isEmpty()) {
            configuration.setProperty("cargo.java.home", this.getTestData().javaHome);
        }
        configuration.setProperty("cargo.logging", LoggingLevel.HIGH.getLevel());
        configuration.setLogger(this.getLogger());
        if (this.getTestData().containerId.startsWith("wildfly-swarm")) {
            configuration.setProperty("cargo.swarm.hollowswarm", "true");
        }
        return configuration;
    }

    public Container createContainer(Configuration configuration) {
        return this.createContainer(this.getTestData().containerType, configuration);
    }

    public Container createContainer(ContainerType type, Configuration configuration) {
        Container container = CONTAINER_FACTORY.createContainer(this.getTestData().containerId, type, configuration);
        container.setLogger(this.getLogger());
        if (container.getType().isLocal()) {
            this.setUpLocalSettings(configuration, (LocalContainer)container);
        }
        return container;
    }

    private void setUpLocalSettings(Configuration configuration, LocalContainer container) {
        if (container.getType() == ContainerType.EMBEDDED) {
            ((EmbeddedLocalContainer)container).setClassLoader(this.classLoader);
        } else if (container.getType() == ContainerType.INSTALLED) {
            this.setUpHome((InstalledLocalContainer)container);
            this.setUpClover((InstalledLocalContainer)container);
        }
        File logFile = new File(new File(this.getTestData().targetDir).getParentFile(), "output.log");
        logFile.delete();
        container.setOutput(logFile.getPath());
        container.setTimeout(this.getTestData().containerTimeout);
    }

    protected EnvironmentTestData getTestData() {
        return this.testData;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public String getName() {
        return super.getName() + " (" + this.getTestData().containerId + "," + this.getTestData().containerType + ")";
    }

    protected void setUp() throws Exception {
        this.getLogger().info("Starting test [" + this.getName() + "]", ((Object)((Object)this)).getClass().getName());
        if (this.getTestData().containerType == ContainerType.EMBEDDED) {
            EmbeddedContainerClasspathResolver resolver = new EmbeddedContainerClasspathResolver();
            this.classLoader = resolver.resolveDependencies(this.testData.containerId, this.installContainer());
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
        }
    }

    protected void tearDown() {
        LocalContainer container;
        if (this.getTestData().containerType == ContainerType.EMBEDDED) {
            Thread.currentThread().setContextClassLoader(null);
        }
        if (this.container != null && this.container.getType().isLocal() && ((container = (LocalContainer)this.container).getState().isStarted() || container.getState().isStarting())) {
            this.getLogger().info("Container is in the [" + container.getState() + "] state, shutting it down now", ((Object)((Object)this)).getClass().getName());
            container.stop();
        }
        this.getLogger().info("Ending test [" + this.getName() + "]", ((Object)((Object)this)).getClass().getName());
    }

    private void setUpClover(InstalledLocalContainer container) {
        if (System.getProperty("cargo.clover.jar") != null) {
            container.addExtraClasspath(System.getProperty("cargo.clover.jar"));
            if (System.getProperty("cargo.clover.license") != null) {
                System.setProperty("clover.license.path", System.getProperty("cargo.clover.license"));
            }
        }
    }

    private void setUpHome(InstalledLocalContainer container) {
        if (this.getTestData().home != null) {
            container.setHome(this.getTestData().home);
        } else if (this.getTestData().installURL != null) {
            container.setHome(this.installContainer());
        }
    }

    private String installContainer() {
        ZipURLInstaller installer = new ZipURLInstaller(this.getTestData().installURL, this.getTestData().downloadDir, this.getTestData().extractDir);
        installer.setLogger(this.getLogger());
        if (this.getTestData().proxy != null) {
            Proxy userProxy = this.getTestData().proxy;
            userProxy.setLogger(this.getLogger());
            installer.setProxy(userProxy);
        }
        installer.install();
        return installer.getHome();
    }
}

