/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.entry.ConfigurationFixtureFactory;
import org.codehaus.cargo.container.configuration.entry.DataSourceFixture;
import org.codehaus.cargo.sample.java.AbstractDataSourceWarCapabilityContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasDataSourceSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasEarSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasXAEmulationValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class TransactionEmulationDataSourceOnStandaloneConfigurationTest
extends AbstractDataSourceWarCapabilityContainerTestCase {
    public TransactionEmulationDataSourceOnStandaloneConfigurationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting DataSource and WAR deployments");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("geronimo2x");
        excludedContainerIds.add("jboss7x");
        excludedContainerIds.add("jboss71x");
        excludedContainerIds.add("jboss72x");
        excludedContainerIds.add("jboss73x");
        excludedContainerIds.add("jboss74x");
        excludedContainerIds.add("jboss75x");
        excludedContainerIds.add("glassfish7x");
        if (EnvironmentTestData.jakartaEeContainers.contains("payara")) {
            excludedContainerIds.add("payara");
        }
        excludedContainerIds.add("wildfly10x");
        suite.addTestSuite(TransactionEmulationDataSourceOnStandaloneConfigurationTest.class, new Validator[]{new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasEarSupportValidator(), new HasDataSourceSupportValidator(ConfigurationType.STANDALONE), new HasXAEmulationValidator(ConfigurationType.STANDALONE)}, excludedContainerIds);
        return suite;
    }

    public void testUserConfiguresDriverAndRequestsDataSourceWithLocalTransactionSupport() throws MalformedURLException {
        DataSourceFixture fixture = ConfigurationFixtureFactory.createDriverConfiguredDataSourceWithLocalTransactionSupport();
        this.testServletThatIssuesGetConnectionFrom(fixture, "datasource-cmt-local");
    }
}

