/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasPortOffsetValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class PortOffsetContainerTest
extends AbstractCargoTestCase {
    private static final String OFFSET = "20";

    public PortOffsetContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on containers supporting offset configuration.");
        suite.addTestSuite(PortOffsetContainerTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasPortOffsetValidator(ConfigurationType.STANDALONE), new HasWarSupportValidator()});
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("cargo.port.offset", OFFSET);
        Configuration configuration = this.createConfiguration(ConfigurationType.STANDALONE);
        System.clearProperty("cargo.port.offset");
        this.setContainer(this.createContainer(configuration));
    }

    public void testStartWithPortOffset() throws Exception {
        int offsetValue = Integer.valueOf(OFFSET);
        int portWithOffset = this.getTestData().port + offsetValue;
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-war"), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL warPingURL = new URL("http://localhost:" + portWithOffset + "/simple-war/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(warPingURL.getPath() + " not started"), (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(warPingURL.getPath() + " not stopped"), (URL)warPingURL, (Logger)this.getLogger());
    }
}

