/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import java.util.Map;
import junit.framework.Assert;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingUtils
extends Assert {
    private static final int TIMEOUT = 20000;

    public static void assertPing(String message, String expectedContent, URL pingURL, Map<String, String> requestProperties, boolean expectTrue, Logger errorLogger) {
        HttpUtils httpUtils = new HttpUtils();
        httpUtils.setLogger(errorLogger);
        HttpUtils.HttpResult result = new HttpUtils.HttpResult();
        boolean success = httpUtils.ping(pingURL, requestProperties, result, 20000L);
        String text = message + ". Failed to ping [" + pingURL.toString() + "], ";
        text = result.responseCode == -1 ? text + "Cannot connect to the URL" : text + "Reason = [" + result.responseMessage + "], Body = [" + result.responseBody + "], Code = [" + result.responseCode + "]";
        if (expectTrue) {
            PingUtils.assertTrue((String)text, (boolean)success);
        } else {
            PingUtils.assertFalse((String)text, (boolean)success);
        }
        if (expectedContent != null) {
            String content = result.responseBody;
            PingUtils.assertNotNull((String)"result.responseBody is null", (Object)content);
            PingUtils.assertTrue((String)(content + " does not contain " + expectedContent), (boolean)content.contains(expectedContent));
        }
    }

    public static void assertPingTrue(String message, String expectedContent, URL pingURL, Map<String, String> requestProperties, Logger errorLogger) {
        PingUtils.assertPing(message, expectedContent, pingURL, requestProperties, true, errorLogger);
    }

    public static void assertPingTrue(String message, String expectedContent, URL pingURL, Logger errorLogger) {
        PingUtils.assertPing(message, expectedContent, pingURL, null, true, errorLogger);
    }

    public static void assertPingFalse(String message, String expectedContent, URL pingURL, Logger errorLogger) {
        PingUtils.assertPing(message, expectedContent, pingURL, null, false, errorLogger);
    }

    public static void assertPingTrue(String message, URL pingURL, Logger errorLogger) {
        PingUtils.assertPingTrue(message, null, pingURL, errorLogger);
    }

    public static void assertPingFalse(String message, URL pingURL, Logger errorLogger) {
        PingUtils.assertPingFalse(message, null, pingURL, errorLogger);
    }
}

