/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.util.CargoException;

public class EmbeddedContainerClasspathResolver {
    private static final Map<String, List<String>> DEPENDENCIES = new HashMap<String, List<String>>();

    public ClassLoader resolveDependencies(String containerId, String containerHome) throws FileNotFoundException {
        List<String> dependencies = DEPENDENCIES.get(containerId);
        if (dependencies == null) {
            return null;
        }
        URLClassLoader classloader = null;
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (JdkUtils.getMajorJavaVersion() < 7) {
                String xerces = System.getProperty("cargo.testdata.xerces-jars");
                if (xerces == null) {
                    throw new IllegalArgumentException("cargo.testdata.xerces-jars not defined");
                }
                File[] xercesJARs = new File(xerces).listFiles();
                if (xercesJARs == null) {
                    throw new FileNotFoundException("Directory not found: " + xerces);
                }
                for (File xercesJAR : xercesJARs) {
                    urls.add(xercesJAR.toURI().toURL());
                }
            }
            if ("jetty9x".equals(containerId)) {
                String cdi = System.getProperty("cargo.testdata.cdi-jars");
                if (cdi == null) {
                    throw new IllegalArgumentException("cargo.testdata.cdi-jars not defined");
                }
                File[] cdiJARs = new File(cdi).listFiles();
                if (cdiJARs == null) {
                    throw new FileNotFoundException("Directory not found: " + cdi);
                }
                for (File cdiJAR : cdiJARs) {
                    urls.add(cdiJAR.toURI().toURL());
                }
            }
            for (String dependencyRelativePath : dependencies) {
                if (dependencyRelativePath.endsWith("*.jar")) {
                    String[] dependencyRelativeSubPaths;
                    boolean found = false;
                    String folders = "";
                    for (String dependencyRelativeSubPath : dependencyRelativeSubPaths = dependencyRelativePath.split("\\|")) {
                        if (!dependencyRelativeSubPath.endsWith("*.jar")) {
                            throw new IllegalArgumentException("Dependency paths with alternatives can only be used for many folder / folder alternatives; i.e. all need to end with *.jar");
                        }
                        File folder = new File(containerHome, dependencyRelativeSubPath.substring(0, dependencyRelativeSubPath.length() - 5));
                        File[] jars = folder.listFiles(new FilenameFilter(){

                            public boolean accept(File dir, String name) {
                                return name.endsWith(".jar");
                            }
                        });
                        if (jars != null) {
                            found = true;
                            for (File jar : jars) {
                                urls.add(jar.toURI().toURL());
                            }
                        }
                        if (folders.length() > 0) {
                            folders = folders + ", ";
                        }
                        folders = folders + folder.toString();
                    }
                    if (found) continue;
                    throw new FileNotFoundException("No files matched in folders: " + folders);
                }
                File dependencyPath = new File(containerHome, dependencyRelativePath);
                if (!dependencyPath.isFile()) {
                    throw new FileNotFoundException(dependencyPath.toString());
                }
                urls.add(dependencyPath.toURI().toURL());
            }
            if (!JdkUtils.isOSX() && JdkUtils.getMajorJavaVersion() < 9) {
                urls.add(JdkUtils.getToolsJar().toURI().toURL());
            }
            classloader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to resolve dependency", (Throwable)e);
        }
        return classloader;
    }

    static {
        ArrayList<String> jetty4xDependencies = new ArrayList<String>();
        jetty4xDependencies.add("lib/*.jar");
        jetty4xDependencies.add("ext/*.jar");
        ArrayList<String> jetty5xDependencies = new ArrayList<String>();
        jetty5xDependencies.add("lib/*.jar");
        jetty5xDependencies.add("ext/*.jar");
        ArrayList<String> jetty6xDependencies = new ArrayList<String>();
        jetty6xDependencies.add("lib/*.jar");
        jetty6xDependencies.add("lib/jsp-2.0/*.jar");
        jetty6xDependencies.add("lib/management/*.jar");
        jetty6xDependencies.add("lib/naming/*.jar");
        jetty6xDependencies.add("lib/plus/*.jar");
        jetty6xDependencies.add("lib/xbean/*.jar");
        ArrayList<String> jetty7xDependencies = new ArrayList<String>();
        jetty7xDependencies.add("lib/*.jar");
        jetty7xDependencies.add("lib/jndi/*.jar");
        jetty7xDependencies.add("lib/jsp/*.jar");
        ArrayList<String> jetty8x9xDependencies = new ArrayList<String>();
        jetty8x9xDependencies.add("lib/*.jar|lib/websocket/*.jar");
        jetty8x9xDependencies.add("lib/annotations/*.jar");
        jetty8x9xDependencies.add("lib/jndi/*.jar");
        jetty8x9xDependencies.add("lib/jsp/*.jar|lib/apache-jsp/*.jar");
        ArrayList<String> tomcat5xDependencies = new ArrayList<String>();
        tomcat5xDependencies.add("bin/*.jar");
        tomcat5xDependencies.add("common/lib/*.jar");
        tomcat5xDependencies.add("server/lib/*.jar");
        ArrayList<String> tomcat6x7x8x9xDependencies = new ArrayList<String>();
        tomcat6x7x8x9xDependencies.add("bin/*.jar");
        tomcat6x7x8x9xDependencies.add("lib/*.jar");
        DEPENDENCIES.put("jetty4x", jetty4xDependencies);
        DEPENDENCIES.put("jetty5x", jetty5xDependencies);
        DEPENDENCIES.put("jetty6x", jetty6xDependencies);
        DEPENDENCIES.put("jetty7x", jetty7xDependencies);
        DEPENDENCIES.put("jetty8x", jetty8x9xDependencies);
        DEPENDENCIES.put("jetty9x", jetty8x9xDependencies);
        DEPENDENCIES.put("tomcat5x", tomcat5xDependencies);
        DEPENDENCIES.put("tomcat6x", tomcat6x7x8x9xDependencies);
        DEPENDENCIES.put("tomcat7x", tomcat6x7x8x9xDependencies);
        DEPENDENCIES.put("tomcat8x", tomcat6x7x8x9xDependencies);
        DEPENDENCIES.put("tomcat9x", tomcat6x7x8x9xDependencies);
    }
}

