/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.installer.Proxy;

public class EnvironmentTestData {
    public String containerId;
    public ContainerType containerType;
    public URL installURL;
    public String downloadDir;
    public String extractDir;
    public int port;
    public int rmiPort;
    public long containerTimeout;
    public String targetDir;
    public String home;
    public String javaHome;
    public Proxy proxy;
    public Map<String, String> testDataArtifacts = new HashMap<String, String>();

    public EnvironmentTestData(String containerId, ContainerType containerType, String targetDirSuffix) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.targetDir = new File(this.getFileFromString(this.getSystemProperty("cargo.target.dir")), targetDirSuffix).getPath();
        this.downloadDir = this.getSystemProperty("cargo.download.dir");
        this.extractDir = new File(this.getFileFromString(this.getSystemProperty("cargo.target.dir")), "cargo/container").getPath();
        this.proxy = this.createProxyElement();
        this.installURL = this.createInstallURL(containerId);
        this.port = this.createPort(containerId, "servlet", 8080);
        this.rmiPort = this.createPort(containerId, "rmi", 1099);
        this.home = this.getSystemProperty("cargo." + containerId + ".home");
        this.javaHome = this.getSystemProperty("cargo." + containerId + ".java.home");
        this.containerTimeout = Long.parseLong(this.getSystemProperty("cargo.containers.timeout", "60000"));
        String deployablesLocation = System.getProperty("cargo.testdata.deployables");
        if (deployablesLocation == null) {
            throw new ContainerException("Property cargo.testdata.deployables not set");
        }
        for (File deployable : new File(deployablesLocation).listFiles()) {
            if (!deployable.isFile()) continue;
            String deployableName = deployable.getName();
            this.testDataArtifacts.put(deployableName.substring(0, deployableName.lastIndexOf(46)), deployable.getAbsolutePath());
        }
    }

    private int createPort(String containerId, String type, int defaultValue) {
        String portString = this.getSystemProperty("cargo." + containerId + "." + type + ".port");
        if (portString == null) {
            portString = this.getSystemProperty("cargo." + type + ".port");
        }
        if (portString == null) {
            return defaultValue;
        }
        return Integer.parseInt(portString);
    }

    private URL createInstallURL(String containerName) {
        URL installURL = null;
        String url = this.getSystemProperty("cargo." + containerName + ".url");
        if (url != null) {
            try {
                installURL = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new ContainerException("invalid install URL [" + url + "]", (Throwable)e);
            }
        }
        return installURL;
    }

    private String getSystemProperty(String name) {
        String result = System.getProperty(name);
        if (result == null || result.isEmpty()) {
            result = null;
        }
        return result;
    }

    private String getSystemProperty(String name, String defaultValue) {
        String result = System.getProperty(name);
        return result == null || result.isEmpty() ? defaultValue : result;
    }

    private File getFileFromString(String fileName) {
        File result = null;
        if (fileName != null) {
            result = new File(fileName);
        }
        return result;
    }

    private Proxy createProxyElement() {
        String proxyHost = this.getSystemProperty("cargo.proxy.host");
        String proxyPort = this.getSystemProperty("cargo.proxy.port", "80");
        String proxyUser = this.getSystemProperty("cargo.proxy.user");
        String proxyPassword = System.getProperty("cargo.proxy.password");
        String proxyExcludeHosts = this.getSystemProperty("cargo.proxy.excludehosts", "");
        Proxy proxy = null;
        if (proxyHost != null) {
            proxy = new Proxy();
            proxy.setHost(proxyHost);
            proxy.setPort(Integer.parseInt(proxyPort));
            if (proxyUser != null) {
                proxy.setUser(proxyUser);
                proxy.setPassword(proxyPassword);
            }
            proxy.setExcludeHosts(proxyExcludeHosts);
        }
        return proxy;
    }

    public String getTestDataFileFor(String artifactName) {
        String result = this.testDataArtifacts.get(artifactName);
        if (result == null) {
            throw new ContainerException("Test data artifact not found [" + artifactName + "]");
        }
        return result;
    }
}

