/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasBundleSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class BundleCapabilityContainerTest
extends AbstractCargoTestCase {
    public BundleCapabilityContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on containers supporting OSGi deployments");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("jboss72x");
        excludedContainerIds.add("jboss73x");
        excludedContainerIds.add("jboss74x");
        excludedContainerIds.add("jboss75x");
        excludedContainerIds.add("wildfly8x");
        excludedContainerIds.add("wildfly9x");
        excludedContainerIds.add("wildfly10x");
        excludedContainerIds.add("wildfly11x");
        excludedContainerIds.add("wildfly12x");
        excludedContainerIds.add("wildfly13x");
        excludedContainerIds.add("wildfly14x");
        suite.addTestSuite(BundleCapabilityContainerTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasBundleSupportValidator()}, excludedContainerIds);
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public void testStartWithBundleDeployed() throws Exception {
        File bundleOutput;
        if (this.getContainer().getId().startsWith("glassfish")) {
            LocalConfiguration configuration = this.getLocalContainer().getConfiguration();
            bundleOutput = new File(configuration.getHome() + "/" + configuration.getPropertyValue("cargo.glassfish.domain.name") + "/config", "bundle-output.txt");
        } else {
            bundleOutput = new File(this.getLocalContainer().getConfiguration().getHome(), "bundle-output.txt");
        }
        BundleCapabilityContainerTest.assertFalse((String)(bundleOutput + " already exists!"), (boolean)bundleOutput.isFile());
        Deployable bundle = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-bundle"), DeployableType.BUNDLE);
        this.getLocalContainer().getConfiguration().addDeployable(bundle);
        this.getLocalContainer().start();
        BundleCapabilityContainerTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        long timeout = System.currentTimeMillis() + 30000L;
        while (!bundleOutput.isFile() && System.currentTimeMillis() < timeout) {
            Thread.sleep(1000L);
        }
        BundleCapabilityContainerTest.assertTrue((String)(bundleOutput + " does not exist!"), (boolean)bundleOutput.isFile());
        BufferedReader reader = new BufferedReader(new FileReader(bundleOutput));
        BundleCapabilityContainerTest.assertEquals((String)"Hello, World", (String)reader.readLine());
        reader.close();
        reader = null;
        System.gc();
        if (this.getContainer().getId().startsWith("geronimo")) {
            Deployer deployer = this.createDeployer(this.getContainer());
            deployer.undeploy(bundle);
        }
        this.getLocalContainer().stop();
        BundleCapabilityContainerTest.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
        reader = new BufferedReader(new FileReader(bundleOutput));
        BundleCapabilityContainerTest.assertEquals((String)"Goodbye, World", (String)reader.readLine());
        reader.close();
        reader = null;
        System.gc();
    }
}

