/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.ConfigurationFixtureFactory;
import org.codehaus.cargo.container.configuration.entry.DataSourceFixture;
import org.codehaus.cargo.sample.java.AbstractDataSourceWarCapabilityContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasDataSourceSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class DataSourceOnStandaloneConfigurationTest
extends AbstractDataSourceWarCapabilityContainerTestCase {
    public DataSourceOnStandaloneConfigurationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting DataSource and WAR deployments");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("geronimo2x");
        excludedContainerIds.add("liberty");
        suite.addTestSuite(DataSourceOnStandaloneConfigurationTest.class, new Validator[]{new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator(), new HasDataSourceSupportValidator(ConfigurationType.STANDALONE)}, excludedContainerIds);
        return suite;
    }

    public void testUserConfiguresDriverAndRequestsDataSource() throws MalformedURLException {
        DataSourceFixture fixture = ConfigurationFixtureFactory.createDataSource();
        if ("glassfish4x".equals(this.getContainer().getId())) {
            fixture.jndiLocation = "jdbc/__default";
        }
        this.testServletThatIssuesGetConnectionFrom(fixture, "datasource");
    }

    public void testMultipleDataSources() throws MalformedURLException {
        DataSourceFixture fixture = ConfigurationFixtureFactory.createDataSource();
        if ("glassfish4x".equals(this.getContainer().getId())) {
            fixture.jndiLocation = "jdbc/__default";
        }
        LocalConfiguration config = this.getLocalContainer().getConfiguration();
        config.setProperty("cargo.datasource.datasource.1", fixture.buildDataSourcePropertyString());
        fixture = ConfigurationFixtureFactory.createAnotherDataSource();
        this.testServletThatIssuesGetConnectionFrom(fixture, "two-datasources");
    }
}

