/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.ConfigurationFixtureFactory;
import org.codehaus.cargo.container.configuration.entry.ResourceFixture;
import org.codehaus.cargo.sample.java.AbstractDataSourceWarCapabilityContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasResourceSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class XADatasourceResourceOnStandaloneConfigurationTest
extends AbstractDataSourceWarCapabilityContainerTestCase {
    public XADatasourceResourceOnStandaloneConfigurationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting Resource and WAR deployments");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("jboss75x");
        excludedContainerIds.add("glassfish3x");
        excludedContainerIds.add("glassfish4x");
        excludedContainerIds.add("glassfish5x");
        excludedContainerIds.add("payara");
        excludedContainerIds.add("weblogic121x");
        excludedContainerIds.add("weblogic122x");
        excludedContainerIds.add("wildfly8x");
        excludedContainerIds.add("wildfly9x");
        excludedContainerIds.add("wildfly10x");
        excludedContainerIds.add("wildfly11x");
        excludedContainerIds.add("wildfly12x");
        excludedContainerIds.add("wildfly13x");
        excludedContainerIds.add("wildfly14x");
        excludedContainerIds.add("wildfly15x");
        excludedContainerIds.add("wildfly16x");
        excludedContainerIds.add("wildfly17x");
        excludedContainerIds.add("wildfly18x");
        excludedContainerIds.add("wildfly19x");
        suite.addTestSuite(XADatasourceResourceOnStandaloneConfigurationTest.class, new Validator[]{new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator(), new HasResourceSupportValidator(ConfigurationType.STANDALONE)}, excludedContainerIds);
        return suite;
    }

    public void testUserConfiguresXADataSourceAsResource() throws MalformedURLException {
        ResourceFixture fixture = ConfigurationFixtureFactory.createXADataSourceAsResource();
        this.addResourceToConfigurationViaProperty(fixture);
        this.testWar("xadatasource");
    }

    protected void addResourceToConfigurationViaProperty(ResourceFixture fixture) {
        LocalConfiguration config = this.getLocalContainer().getConfiguration();
        config.setProperty("cargo.resource.resource", fixture.buildResourcePropertyString());
    }
}

