/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.War;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.jboss.AbstractJBossCapabilityTestCase;
import org.codehaus.cargo.sample.java.validator.HasInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.HasRemoteContainerValidator;
import org.codehaus.cargo.sample.java.validator.HasRemoteDeployerValidator;
import org.codehaus.cargo.sample.java.validator.HasRuntimeConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.Logger;

public class RemoteDeploymentTest
extends AbstractCargoTestCase {
    private FileHandler fileHandler = new DefaultFileHandler();
    private InstalledLocalContainer localContainer;
    private Deployer deployer;
    private WAR war;

    public RemoteDeploymentTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that perform remote deployments on remote containers");
        suite.addTestSuite(RemoteDeploymentTest.class, new Validator[]{new HasRemoteContainerValidator(), new HasRuntimeConfigurationValidator(), new HasRemoteDeployerValidator(), new HasWarSupportValidator()});
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.RUNTIME)));
        this.startLocalContainer();
        ArrayList<File> filesToAddToClasspath = new ArrayList<File>();
        if (this.getTestData().containerId.equals("glassfish3x") || this.getTestData().containerId.equals("glassfish4x") || this.getTestData().containerId.equals("glassfish5x") || this.getTestData().containerId.equals("payara")) {
            for (File jar : new File(this.localContainer.getHome(), "glassfish/modules").listFiles()) {
                if (!jar.isFile()) continue;
                filesToAddToClasspath.add(jar);
            }
        } else if (this.getTestData().containerId.startsWith("jboss")) {
            int jbossVersion = Integer.parseInt(this.getTestData().containerId.substring(5, this.getTestData().containerId.length() - 1));
            if (jbossVersion < 10 && jbossVersion >= 5 || jbossVersion >= 50) {
                if (jbossVersion == 7 || jbossVersion >= 70 || jbossVersion == 8) {
                    AbstractJBossCapabilityTestCase.addAllJars(new File(this.localContainer.getHome(), "modules"), filesToAddToClasspath);
                } else {
                    for (File jar : new File(this.localContainer.getHome(), "lib").listFiles()) {
                        if (!jar.isFile()) continue;
                        filesToAddToClasspath.add(jar);
                    }
                    for (File jar : new File(this.localContainer.getHome(), "common/lib").listFiles()) {
                        if (!jar.isFile()) continue;
                        filesToAddToClasspath.add(jar);
                    }
                }
            }
        } else if (this.getTestData().containerId.startsWith("wildfly")) {
            Thread.sleep(500L);
        }
        URL[] urlsArray = new URL[filesToAddToClasspath.size()];
        for (int i = 0; i < filesToAddToClasspath.size(); ++i) {
            urlsArray[i] = ((File)filesToAddToClasspath.get(i)).toURI().toURL();
        }
        URLClassLoader classLoader = new URLClassLoader(urlsArray, ((Object)((Object)this)).getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        if (!(this.getRemoteContainer().getId().equals("glassfish3x") || this.getRemoteContainer().getId().equals("glassfish4x") || this.getRemoteContainer().getId().equals("glassfish5x") || this.getRemoteContainer().getId().equals("payara") || this.getRemoteContainer().getId().startsWith("weblogic"))) {
            this.getRemoteContainer().getConfiguration().setProperty("cargo.remote.username", "cargo");
            this.getRemoteContainer().getConfiguration().setProperty("cargo.remote.password", "password");
        } else if (this.getRemoteContainer().getId().startsWith("weblogic")) {
            this.getRemoteContainer().getConfiguration().setProperty("cargo.weblogic.installation.home", this.localContainer.getHome());
        }
        this.war = (WAR)new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-war"), DeployableType.WAR);
        this.deployer = this.createDeployer(DeployerType.REMOTE, (Container)this.getRemoteContainer());
    }

    private void startLocalContainer() throws Exception {
        EnvironmentTestData testData = this.getTestData();
        String message = "You have implemented the Remote container. Please also implement a standalone local container for the CARGO samples to pass.";
        RemoteDeploymentTest.assertTrue((String)"You have implemented the Remote container. Please also implement a standalone local container for the CARGO samples to pass.", (boolean)new HasInstalledLocalContainerValidator().validate(this.getTestData().containerId, ContainerType.INSTALLED));
        RemoteDeploymentTest.assertTrue((String)"You have implemented the Remote container. Please also implement a standalone local container for the CARGO samples to pass.", (boolean)new HasStandaloneConfigurationValidator().validate(this.getTestData().containerId, ContainerType.INSTALLED));
        ContainerType oldContainerType = this.getTestData().containerType;
        testData.containerType = ContainerType.INSTALLED;
        this.localContainer = (InstalledLocalContainer)this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE));
        testData.containerType = oldContainerType;
        if (this.getTestData().containerId.startsWith("jetty")) {
            int jettyVersion = Integer.parseInt(this.getTestData().containerId.substring(5, this.getTestData().containerId.length() - 1));
            Deployable jettyDeployerApplication = jettyVersion <= 6 ? new DefaultDeployableFactory().createDeployable(this.localContainer.getId(), this.getTestData().getTestDataFileFor("cargo-jetty-6-and-earlier-deployer"), DeployableType.WAR) : new DefaultDeployableFactory().createDeployable(this.localContainer.getId(), this.getTestData().getTestDataFileFor("cargo-jetty-7-and-onwards-deployer"), DeployableType.WAR);
            this.localContainer.getConfiguration().addDeployable(jettyDeployerApplication);
        } else if (this.getTestData().containerId.startsWith("tomcat")) {
            int tomcatVersion = Integer.parseInt(this.getTestData().containerId.substring(6, this.getTestData().containerId.length() - 1));
            if (tomcatVersion < 7) {
                List users = User.parseUsers((String)"cargo:password:manager");
                this.localContainer.getConfiguration().getUsers().addAll(users);
            } else {
                List users = User.parseUsers((String)"cargo:password:manager-script");
                this.localContainer.getConfiguration().getUsers().addAll(users);
            }
        } else if (this.getTestData().containerId.startsWith("tomee")) {
            List users = User.parseUsers((String)"cargo:password:manager-script");
            this.localContainer.getConfiguration().getUsers().addAll(users);
        } else if (this.getTestData().containerId.startsWith("wildfly")) {
            List users = User.parseUsers((String)"cargo:password:admin");
            this.localContainer.getConfiguration().getUsers().addAll(users);
        }
        this.localContainer.start();
    }

    @Override
    protected void tearDown() {
        this.localContainer.stop();
    }

    public void testDeployUndeployRedeployWarRemotely() throws Exception {
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        this.deployer.deploy((Deployable)this.war);
        PingUtils.assertPingTrue((String)"simple war not correctly deployed", (URL)warPingURL, (Logger)this.getLogger());
        this.deployer.undeploy((Deployable)this.war);
        PingUtils.assertPingFalse((String)"simple war not correctly undeployed", (URL)warPingURL, (Logger)this.getLogger());
        this.deployer.deploy((Deployable)this.war);
        PingUtils.assertPingTrue((String)"simple war not correctly redeployed", (URL)warPingURL, (Logger)this.getLogger());
        if ("jonas4x".equals(this.getTestData().containerId)) {
            return;
        }
        Deployable modifiedDeployable = this.modifyWar((Deployable)this.war);
        File modifiedWar = new File(modifiedDeployable.getFile());
        if (!modifiedWar.isFile()) {
            throw new FileNotFoundException("Modified WAR \"" + modifiedWar + "\" doesn't exist");
        }
        this.deployer.redeploy(modifiedDeployable);
        URL newWarPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/some.html");
        PingUtils.assertPingTrue((String)"simple war not correctly redeployed", (URL)newWarPingURL, (Logger)this.getLogger());
    }

    public void testChangeWarContextAndDeployUndeployRemotely() throws Exception {
        this.war.setContext("simple");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/" + this.war.getContext() + "/index.jsp");
        this.deployer.deploy((Deployable)this.war);
        PingUtils.assertPingTrue((String)"simple war not correctly deployed", (URL)warPingURL, (Logger)this.getLogger());
        this.deployer.undeploy((Deployable)this.war);
        PingUtils.assertPingFalse((String)"simple war not correctly undeployed", (URL)warPingURL, (Logger)this.getLogger());
    }

    private Deployable modifyWar(Deployable originalDeployable) throws Exception {
        File tmpDir = new File(new File(this.getTestData().targetDir).getParent(), "modified-war");
        tmpDir.mkdirs();
        if (!tmpDir.isDirectory()) {
            throw new FileNotFoundException("Cannot create modified WAR temporary directory \"" + tmpDir + "\"");
        }
        File htmlFile = new File(tmpDir, "some.html");
        FileWriter fw = new FileWriter(htmlFile);
        fw.write("It works...");
        fw.close();
        File originalWar = new File(originalDeployable.getFile());
        File updatedWar = new File(tmpDir, originalWar.getName());
        this.fileHandler.copyFile(originalWar.getPath(), updatedWar.getPath());
        War warTask = (War)new AntUtils().createProject().createTask("war");
        warTask.setUpdate(true);
        warTask.setDestFile(updatedWar);
        FileSet fileSet = new FileSet();
        fileSet.setFile(htmlFile);
        warTask.addFileset(fileSet);
        warTask.execute();
        return new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), updatedWar.getPath(), DeployableType.WAR);
    }
}

