/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.net.URL;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.Copy;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractWarCapabilityContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.AntUtils;

public class WarCapabilityContainerTest
extends AbstractWarCapabilityContainerTestCase {
    public WarCapabilityContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting WAR deployments");
        suite.addTestSuite(WarCapabilityContainerTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator()});
        return suite;
    }

    public void testDeployWarDefinedWithRelativePath() throws Exception {
        File artifactDir = new File(this.getTestData().targetDir).getParentFile();
        File artifactFile = new File(artifactDir, "simple.war").getAbsoluteFile();
        Copy copyTask = (Copy)new AntUtils().createProject().createTask("copy");
        copyTask.setTofile(artifactFile);
        copyTask.setFile(new File(this.getTestData().getTestDataFileFor("simple-war")));
        copyTask.execute();
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), artifactFile.getAbsolutePath(), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple/index.jsp");
        this.startAndStop(warPingURL);
    }
}

