/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.entry.ConfigurationFixtureFactory;
import org.codehaus.cargo.container.configuration.entry.ResourceFixture;
import org.codehaus.cargo.sample.java.AbstractResourceOnStandaloneConfigurationTest;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasResourceSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class JmsQueueResourceOnStandaloneConfigurationTest
extends AbstractResourceOnStandaloneConfigurationTest {
    public JmsQueueResourceOnStandaloneConfigurationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    public Container createContainer(ContainerType type, Configuration configuration) {
        InstalledLocalContainer container = (InstalledLocalContainer)super.createContainer(type, configuration);
        return container;
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting Resource and WAR deployments");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("jboss75x");
        excludedContainerIds.add("resin2x");
        excludedContainerIds.add("resin3x");
        excludedContainerIds.add("resin31x");
        excludedContainerIds.add("resin4x");
        excludedContainerIds.add("tomcat4x");
        excludedContainerIds.add("tomcat5x");
        excludedContainerIds.add("tomcat6x");
        excludedContainerIds.add("tomcat7x");
        excludedContainerIds.add("tomcat8x");
        excludedContainerIds.add("tomcat9x");
        suite.addTestSuite(JmsQueueResourceOnStandaloneConfigurationTest.class, new Validator[]{new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator(), new HasResourceSupportValidator(ConfigurationType.STANDALONE)}, excludedContainerIds);
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (this.getTestData().containerId.equals("wildfly9x")) {
            this.getLocalContainer().getConfiguration().setProperty("cargo.jboss.configuration", "standalone-full");
            this.getLocalContainer().getConfiguration().setProperty("cargo.wildfly.script.cli.embedded.journal", "target/test-classes/wildfly/wildfly9/jms-journal.cli");
        } else if (this.getTestData().containerId.startsWith("wildfly1")) {
            this.getLocalContainer().getConfiguration().setProperty("cargo.jboss.configuration", "standalone-full");
            this.getLocalContainer().getConfiguration().setProperty("cargo.wildfly.script.cli.embedded.journal", "target/test-classes/wildfly/wildfly10/jms-journal.cli");
        }
    }

    public void testUserConfiguresJmsQueueAsResource() throws MalformedURLException {
        ResourceFixture fixture = ConfigurationFixtureFactory.createJmsQueueAsResource();
        this.addResourceToConfigurationViaProperty(fixture);
        this.testWar("jms");
    }
}

