/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import junit.framework.Test;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasSpawnSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class SpawnContainerTest
extends AbstractCargoTestCase {
    public SpawnContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on containers supporting spawned process.");
        suite.addTestSuite(SpawnContainerTest.class, new Validator[]{new IsLocalContainerValidator(), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasSpawnSupportValidator(ConfigurationType.STANDALONE), new HasWarSupportValidator()});
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createConfiguration(ConfigurationType.STANDALONE);
        configuration.setProperty("cargo.process.spawn", "true");
        Container container = this.createContainer(configuration);
        this.setContainer(container);
        this.getLocalContainer().setOutput(null);
    }

    public void testStartSpawned() throws Exception {
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-war"), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL pingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(pingURL.getPath() + " not started"), (URL)pingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(pingURL.getPath() + " not stopped"), (URL)pingURL, (Logger)this.getLogger());
    }
}

