/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasAuthenticationSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class WarAuthenticationTest
extends AbstractCargoTestCase {
    public WarAuthenticationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting WAR deployments and which support authentication");
        suite.addTestSuite(WarAuthenticationTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator(), new HasAuthenticationSupportValidator(ConfigurationType.STANDALONE)});
        return suite;
    }

    public void testExecutionWithAuthenticatedWar() throws Exception {
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("authentication-war"), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        List users = User.parseUsers((String)"someone:p@ssw0rd:cargo");
        this.getLocalContainer().getConfiguration().getUsers().addAll(users);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/authentication-war/test");
        this.getLocalContainer().start();
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])"someone:p@ssw0rd".getBytes())));
        PingUtils.assertPingTrue((String)"Failed authentication", (String)"Principal name [someone], Is user in \"cargo\" role [true]", (URL)warPingURL, requestProperties, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"Authentication war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

