/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class WarRootContextTest
extends AbstractCargoTestCase {
    public WarRootContextTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting WAR deployments");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("geronimo1x");
        excludedContainerIds.add("geronimo2x");
        excludedContainerIds.add("geronimo3x");
        excludedContainerIds.add("glassfish2x");
        excludedContainerIds.add("jo1x");
        excludedContainerIds.add("jonas4x");
        excludedContainerIds.add("jonas5x");
        excludedContainerIds.add("weblogic8x");
        excludedContainerIds.add("weblogic9x");
        excludedContainerIds.add("weblogic10x");
        excludedContainerIds.add("weblogic103x");
        excludedContainerIds.add("weblogic12x");
        excludedContainerIds.add("weblogic121x");
        excludedContainerIds.add("weblogic122x");
        excludedContainerIds.add("wildfly8x");
        excludedContainerIds.add("wildfly9x");
        excludedContainerIds.add("wildfly10x");
        suite.addTestSuite(WarRootContextTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator()}, excludedContainerIds);
        return suite;
    }

    public void testDeployWarDefinedWithRootPath() throws Exception {
        WAR war = (WAR)new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-war"), DeployableType.WAR);
        war.setContext("/");
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(warPingURL.getPath() + " not started"), (String)"Sample page for testing", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(warPingURL.getPath() + " not stopped"), (URL)warPingURL, (Logger)this.getLogger());
    }
}

