/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jonas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import junit.framework.Test;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class JonasStandaloneConfigurationTest
extends AbstractCargoTestCase {
    public JonasStandaloneConfigurationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Test that verifies JOnAS-specific standalone local configuration options");
        suite.addTestSuite(JonasStandaloneConfigurationTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"jonas"}), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator()});
        return suite;
    }

    public void testConfiguratorProperties() throws Exception {
        System.setProperty("cargo.jonas.configurator.ajpPort", "123456");
        System.setProperty("cargo.jonas.configurator.ajpConnectorActivation", "true");
        this.checkForValue("123456", true);
        System.getProperties().remove("cargo.jonas.configurator.ajpPort");
        System.getProperties().remove("cargo.jonas.configurator.ajpConnectorActivation");
        this.checkForValue("123456", false);
    }

    protected void checkForValue(String check, boolean checkExists) throws Exception {
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        this.getInstalledLocalContainer().getConfiguration().configure((LocalContainer)this.getInstalledLocalContainer());
        File conf = new File(this.getInstalledLocalContainer().getConfiguration().getHome(), "conf");
        if (!conf.isDirectory()) {
            throw new IllegalArgumentException(conf + " is not a directory");
        }
        ArrayList<Object> serverXmlFiles = new ArrayList<Object>();
        if (this.getContainer().getId().equals("jonas4x")) {
            serverXmlFiles.add(new File(conf, "server.xml"));
        } else if (this.getContainer().getId().equals("jonas5x")) {
            for (File confFile : conf.listFiles()) {
                if (!confFile.getName().startsWith("tomcat") || !confFile.getName().endsWith(".xml")) continue;
                serverXmlFiles.add(confFile);
            }
            File deploy = new File(this.getInstalledLocalContainer().getConfiguration().getHome(), "deploy");
            if (deploy.isDirectory()) {
                for (File deployFile : deploy.listFiles()) {
                    if (!deployFile.getName().startsWith("tomcat") || !deployFile.getName().endsWith(".xml")) continue;
                    serverXmlFiles.add(deployFile);
                }
            }
        }
        if (serverXmlFiles.isEmpty()) {
            throw new IllegalArgumentException("Unknown container: " + this.getContainer().getId());
        }
        for (File file : serverXmlFiles) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            Throwable throwable = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (checkExists) {
                        if (!line.contains(check)) continue;
                        return;
                    }
                    JonasStandaloneConfigurationTest.assertTrue((String)("Line in file " + file + " contains " + check), (!line.contains(check) ? 1 : 0) != 0);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        if (checkExists) {
            JonasStandaloneConfigurationTest.fail((String)("None of the files " + serverXmlFiles + " contains " + check));
        }
    }
}

