/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.DataSourceFixture;
import org.codehaus.cargo.sample.java.AbstractWarTestCase;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractDataSourceWarCapabilityContainerTestCase
extends AbstractWarTestCase {
    public AbstractDataSourceWarCapabilityContainerTestCase(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    protected void testServletThatIssuesGetConnectionFrom(DataSourceFixture fixture, String type) throws MalformedURLException {
        this.addDataSourceToConfigurationViaProperty(fixture);
        this.testWar(type);
    }

    @Override
    public Container createContainer(Configuration configuration) {
        InstalledLocalContainer container = (InstalledLocalContainer)super.createContainer(configuration);
        this.setUpDerby(container);
        return container;
    }

    protected void addDataSourceToConfigurationViaProperty(DataSourceFixture fixture) {
        LocalConfiguration config = this.getLocalContainer().getConfiguration();
        config.setProperty("cargo.datasource.datasource", fixture.buildDataSourcePropertyString());
    }

    private void setUpDerby(InstalledLocalContainer container) {
        if ("glassfish3x".equals(container.getId()) || "glassfish4x".equals(container.getId()) || "glassfish5x".equals(container.getId()) || "payara".equals(container.getId())) {
            return;
        }
        String jdbcdriver = System.getProperty("cargo.testdata.derby-jar");
        if (jdbcdriver == null) {
            throw new CargoException("Please set property [cargo.testdata.derby-jar] to a valid location of derby.jar");
        }
        container.addExtraClasspath(jdbcdriver);
        container.getSystemProperties().put("derby.system.home", this.getTestData().targetDir);
        container.getSystemProperties().put("derby.stream.error.logSeverityLevel", "0");
    }
}

