/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import junit.framework.Test;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class AllLocalContainerTest
extends AbstractCargoTestCase {
    public AllLocalContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that can run on all local containers");
        suite.addTestSuite(AllLocalContainerTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator()});
        return suite;
    }

    public void testStartWithNoDeployable() throws Exception {
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        this.getLocalContainer().start();
        AllLocalContainerTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        try {
            this.getLocalContainer().start();
            AllLocalContainerTest.fail((String)"the second start attempt did not fail");
        }
        catch (ContainerException expected) {
            AllLocalContainerTest.assertTrue((String)(expected.getMessage() + " does not contain the word 'restart'"), (boolean)expected.getMessage().contains("restart"));
        }
        this.getLocalContainer().stop();
        AllLocalContainerTest.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
    }

    public void testRestartWithNoDeployable() throws Exception {
        if ("glassfish4x".equals(this.getTestData().containerId) || "glassfish5x".equals(this.getTestData().containerId)) {
            return;
        }
        if ("jonas4x".equals(this.getTestData().containerId)) {
            return;
        }
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        if (ContainerType.EMBEDDED.equals((Object)this.getContainer().getType()) && this.getTestData().containerId.startsWith("jetty")) {
            return;
        }
        this.getLocalContainer().start();
        AllLocalContainerTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        this.getLocalContainer().restart();
        AllLocalContainerTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        this.getLocalContainer().stop();
        AllLocalContainerTest.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
        this.getLocalContainer().restart();
        AllLocalContainerTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        this.getLocalContainer().stop();
        AllLocalContainerTest.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
    }
}

