/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.tomcat;

import java.io.File;
import java.net.URL;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.log.Logger;

public class WarExtraClasspathWithContextTest
extends AbstractCargoTestCase {
    public WarExtraClasspathWithContextTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers to test extra classpath with  META-INF/context.xml file");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("tomcat4x");
        excludedContainerIds.add("tomcat5x");
        excludedContainerIds.add("tomcat10x");
        excludedContainerIds.add("tomee9x");
        suite.addTestSuite(WarExtraClasspathWithContextTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"tomcat", "tomee"}), new HasWarSupportValidator(), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator()}, excludedContainerIds);
        return suite;
    }

    public void testLoadClassOnWarWithContextXmlFile() throws Exception {
        File artifactDir = new File(this.getTestData().targetDir).getParentFile();
        Copy copyTask = (Copy)new AntUtils().createProject().createTask("copy");
        copyTask.setTofile(new File(artifactDir, "tomcat-context.war"));
        copyTask.setFile(new File(this.getTestData().getTestDataFileFor("tomcatcontext-war")));
        copyTask.execute();
        String simpleJar = System.getProperty("cargo.testdata.simple-jar");
        if (simpleJar == null) {
            throw new CargoException("Please set property [cargo.testdata.simple-jar] to a valid location of simple-jar");
        }
        WAR war = (WAR)new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), new File(artifactDir, "tomcat-context.war").getPath(), DeployableType.WAR);
        war.setExtraClasspath(new String[]{simpleJar});
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        this.getLocalContainer().getConfiguration().setProperty("cargo.tomcat.copywars", "false");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/tomcat-context/");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"tomcat context war not started", (String)"Test value is [test value]", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"tomcat context war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }

    public void testLoadClassOnExpandedWarWithContextXmlFile() throws Exception {
        File artifactDir = new File(this.getTestData().targetDir).getParentFile();
        Expand expandTask = (Expand)new AntUtils().createProject().createTask("unwar");
        expandTask.setDest(new File(artifactDir, "tomcat-context"));
        expandTask.setSrc(new File(this.getTestData().getTestDataFileFor("tomcatcontext-war-link-simple-jar")));
        expandTask.execute();
        String simpleJar = System.getProperty("cargo.testdata.simple-jar");
        if (simpleJar == null) {
            throw new CargoException("Please set property [cargo.testdata.simple-jar] to a valid location of simple-jar");
        }
        WAR war = (WAR)new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), new File(artifactDir, "tomcat-context").getPath(), DeployableType.WAR);
        war.setExtraClasspath(new String[]{simpleJar});
        this.getLocalContainer().getConfiguration().addDeployable((Deployable)war);
        this.getLocalContainer().getConfiguration().setProperty("cargo.tomcat.copywars", "false");
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/tomcat-context/");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"tomcat context war not started", (String)"Test value is [test value]", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"tomcat context war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

