/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import junit.framework.Test;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasEarSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class EarCapabilityContainerTest
extends AbstractCargoTestCase {
    public EarCapabilityContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on containers supporting EAR deployments");
        suite.addTestSuite(EarCapabilityContainerTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasEarSupportValidator()});
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public void testStartWithOneEmptyEarDeployed() throws Exception {
        if (this.getContainer().getId().startsWith("geronimo")) {
            return;
        }
        Deployable ear = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("empty-ear"), DeployableType.EAR);
        this.getLocalContainer().getConfiguration().addDeployable(ear);
        this.getLocalContainer().start();
        EarCapabilityContainerTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        this.getLocalContainer().stop();
        EarCapabilityContainerTest.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
    }

    public void testStartWithOneEarWithOneWarDeployed() throws Exception {
        Deployable ear = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-ear"), DeployableType.EAR);
        this.getLocalContainer().getConfiguration().addDeployable(ear);
        URL earPingURL = new URL("http://localhost:" + this.getTestData().port + "/simpleweb/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"simple ear not started", (URL)earPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"simple ear not stopped", (URL)earPingURL, (Logger)this.getLogger());
    }
}

