/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.log.Logger;

public class ExtraClasspathOnStandaloneConfigurationTest
extends AbstractCargoTestCase {
    public ExtraClasspathOnStandaloneConfigurationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers to test extra classpath");
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("geronimo1x");
        excludedContainerIds.add("jetty11x");
        excludedContainerIds.add("glassfish6x");
        excludedContainerIds.add("tomcat10x");
        excludedContainerIds.add("tomee9x");
        suite.addTestSuite(ExtraClasspathOnStandaloneConfigurationTest.class, new Validator[]{new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasWarSupportValidator()}, excludedContainerIds);
        return suite;
    }

    public void testLoadClass() throws MalformedURLException {
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("classpath-war"), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/classpath-war/test");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"simple war should have been started at this point", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"simple war should have been stopped at this point", (URL)warPingURL, (Logger)this.getLogger());
    }

    @Override
    public Container createContainer(Configuration configuration) {
        InstalledLocalContainer container = (InstalledLocalContainer)super.createContainer(configuration);
        String simpleJar = System.getProperty("cargo.testdata.simple-jar");
        if (simpleJar == null) {
            throw new CargoException("Please set property [cargo.testdata.simple-jar] to a valid location of simple-jar");
        }
        container.addExtraClasspath(simpleJar);
        return container;
    }
}

