/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.net.URL;
import org.apache.tools.ant.taskdefs.Expand;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractWarTestCase;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.util.AntUtils;

public abstract class AbstractWarCapabilityContainerTestCase
extends AbstractWarTestCase {
    public AbstractWarCapabilityContainerTestCase(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public void testDeployWarStatically() throws Exception {
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-war"), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        this.startAndStop(warPingURL);
    }

    public void testStartWithOneExpandedWarDeployed() throws Exception {
        if (this.getContainer().getId().startsWith("geronimo")) {
            return;
        }
        File artifactDir = new File(this.getTestData().targetDir).getParentFile();
        Expand expandTask = (Expand)new AntUtils().createProject().createTask("unwar");
        expandTask.setDest(new File(artifactDir, "expanded-war"));
        expandTask.setSrc(new File(this.getTestData().getTestDataFileFor("expanded-war")));
        expandTask.execute();
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), new File(artifactDir, "expanded-war").getPath(), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/expanded-war/index.html");
        this.startAndStop(warPingURL);
    }
}

