/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.net.URL;
import junit.framework.Test;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.sample.java.AbstractWarCapabilityContainerTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasExistingConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class ExistingConfigurationTest
extends AbstractWarCapabilityContainerTestCase {
    public ExistingConfigurationTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that verify that existing configuration work by doing local WAR deployments");
        suite.addTestSuite(ExistingConfigurationTest.class, new Validator[]{new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasExistingConfigurationValidator(), new HasWarSupportValidator()});
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LocalContainer tmpContainer = (LocalContainer)this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE));
        tmpContainer.getConfiguration().configure(tmpContainer);
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.EXISTING)));
    }

    @Override
    public void startAndStop(URL warPingURL) {
        String testFileName = "cargo-test/test.file";
        File testFile = new File(this.getLocalContainer().getConfiguration().getHome(), testFileName);
        ExistingConfigurationTest.assertFalse((String)("File " + testFile + " already exists"), (boolean)testFile.exists());
        FileConfig fileConfig = new FileConfig();
        fileConfig.setFile(this.getTestData().getTestDataFileFor("simple-war"));
        fileConfig.setToFile(testFileName);
        this.getLocalContainer().getConfiguration().setConfigFileProperty(fileConfig);
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)(warPingURL.getPath() + " not started"), (URL)warPingURL, (Logger)this.getLogger());
        ExistingConfigurationTest.assertTrue((String)("File " + testFile + " was not configured"), (boolean)testFile.exists());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)(warPingURL.getPath() + " not stopped"), (URL)warPingURL, (Logger)this.getLogger());
    }

    @Override
    public void testStartWithOneExpandedWarDeployed() throws Exception {
        if (!"weblogic12x".equals(this.getContainer().getId())) {
            super.testStartWithOneExpandedWarDeployed();
        }
    }
}

