/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jonas;

import java.net.URL;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasLocalDeployerValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.Logger;

public class JonasDeploymentPlanTest
extends AbstractCargoTestCase {
    private FileHandler fileHandler = new DefaultFileHandler();

    public JonasDeploymentPlanTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("jonas4x");
        CargoTestSuite suite = new CargoTestSuite("Test that verifies JOnAS-specific standalone local configuration options");
        suite.addTestSuite(JonasDeploymentPlanTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"jonas"}), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasLocalDeployerValidator()}, excludedContainerIds);
        return suite;
    }

    public void testDeploymentPlanHotDeployment() throws Exception {
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
        String urlInternal = this.fileHandler.createDirectory(this.getInstalledLocalContainer().getHome(), "repositories/url-internal");
        this.fileHandler.copyFile(this.getTestData().getTestDataFileFor("simple-war"), urlInternal + "/cargo-simple-war.war");
        Deployable deploymentPlan = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), "target/test-classes/jonas-deploymentplan.xml", DeployableType.FILE);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/cargo-simple-war/index.jsp");
        this.getLocalContainer().start();
        PingUtils.assertPingFalse((String)"simple war should not be started at this point", (URL)warPingURL, (Logger)this.getLogger());
        Deployer deployer = this.createDeployer(this.getContainer());
        URLDeployableMonitor deployableMonitor = new URLDeployableMonitor(warPingURL);
        deployableMonitor.setLogger(this.getLogger());
        deployer.deploy(deploymentPlan, (DeployableMonitor)deployableMonitor);
        PingUtils.assertPingTrue((String)"simple war should have been started at this point", (URL)warPingURL, (Logger)this.getLogger());
        deployer.undeploy(deploymentPlan, (DeployableMonitor)deployableMonitor);
        PingUtils.assertPingFalse((String)"simple war should have been stopped at this point", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
    }
}

