/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.io.File;
import java.net.URL;
import java.util.UUID;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.Copy;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasWarSupportValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.log.Logger;

public class SystemPropertyCapabilityTest
extends AbstractCargoTestCase {
    public SystemPropertyCapabilityTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Tests that run on local containers supporting system properties");
        suite.addTestSuite(SystemPropertyCapabilityTest.class, new Validator[]{new IsInstalledLocalContainerValidator(), new HasWarSupportValidator()});
        return suite;
    }

    public void testSystemProperty() throws Exception {
        String random = UUID.randomUUID().toString();
        File artifactDir = new File(this.getTestData().targetDir).getParentFile();
        File artifactFile = new File(artifactDir, "systemproperty.war").getAbsoluteFile();
        Copy copyTask = (Copy)new AntUtils().createProject().createTask("copy");
        copyTask.setTofile(artifactFile);
        copyTask.setFile(new File(this.getTestData().getTestDataFileFor("systemproperty-war")));
        copyTask.execute();
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), artifactFile.getAbsolutePath(), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL pingURL = new URL("http://localhost:" + this.getTestData().port + "/systemproperty/test?systemPropertyName=random");
        this.getInstalledLocalContainer().getSystemProperties().put("random", random);
        this.getLocalContainer().start();
        SystemPropertyCapabilityTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        PingUtils.assertPingTrue((String)(pingURL.getPath() + " not started"), (String)random, (URL)pingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        SystemPropertyCapabilityTest.assertEquals((Object)State.STOPPED, (Object)this.getContainer().getState());
        PingUtils.assertPingFalse((String)(pingURL.getPath() + " not stopped"), (URL)pingURL, (Logger)this.getLogger());
    }
}

