/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.tomcat;

import java.io.File;
import java.net.URL;
import java.util.TreeSet;
import junit.framework.Test;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasDirectoryPackagerValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.log.Logger;

public class TomcatTLSTest
extends AbstractCargoTestCase {
    public TomcatTLSTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("tomcat4x");
        excludedContainerIds.add("tomcat10x");
        excludedContainerIds.add("tomee9x");
        CargoTestSuite suite = new CargoTestSuite("Tests that can run on installed local Tomcat containers supporting TLS configuration.");
        suite.addTestSuite(TomcatTLSTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"tomcat", "tomee"}), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator(), new HasDirectoryPackagerValidator()}, excludedContainerIds);
        return suite;
    }

    public void testTlsConfigContainer() throws Exception {
        File localhostJksFile = new File("target/test-classes/localhost.jks");
        TomcatTLSTest.assertTrue((boolean)localhostJksFile.isFile());
        StandaloneLocalConfiguration configuration = (StandaloneLocalConfiguration)this.createConfiguration(ConfigurationType.STANDALONE);
        configuration.setProperty("cargo.protocol", "https");
        configuration.setProperty("cargo.tomcat.connector.keystoreFile", localhostJksFile.getAbsolutePath());
        configuration.setProperty("cargo.tomcat.connector.keystorePass", "password");
        configuration.setProperty("cargo.tomcat.connector.keystoreType", "jks");
        configuration.setProperty("cargo.tomcat.connector.keyAlias", "localhost");
        configuration.setProperty("cargo.tomcat.connector.truststoreFile", localhostJksFile.getAbsolutePath());
        configuration.setProperty("cargo.tomcat.connector.truststorePass", "password");
        configuration.setProperty("cargo.tomcat.connector.truststoreType", "jks");
        configuration.setProperty("cargo.tomcat.connector.clientAuth", "want");
        InstalledLocalContainer container = (InstalledLocalContainer)this.createContainer((Configuration)configuration);
        Deployable war = new DefaultDeployableFactory().createDeployable(container.getId(), this.getTestData().getTestDataFileFor("simple-war"), DeployableType.WAR);
        configuration.addDeployable(war);
        configuration.configure((LocalContainer)container);
        URL warPingURL = new URL("https://localhost:" + this.getTestData().port + "/simple-war/index.jsp");
        container.start();
        PingUtils.assertPingTrue((String)"simple war not started", (URL)warPingURL, (Logger)this.getLogger());
        container.stop();
        PingUtils.assertPingFalse((String)"simple war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

