/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.tomcat;

import java.io.File;
import java.net.URL;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.AbstractCargoTestCase;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.PingUtils;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.log.Logger;

public class TomcatWarTest
extends AbstractCargoTestCase {
    public TomcatWarTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        TreeSet<String> excludedContainerIds = new TreeSet<String>();
        excludedContainerIds.add("tomcat4x");
        CargoTestSuite suite = new CargoTestSuite("Tests that can run on Tomcat containers supporting META-INF/context.xml files");
        suite.addTestSuite(TomcatWarTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"tomcat", "tomee"}), new IsLocalContainerValidator(), new HasStandaloneConfigurationValidator()}, excludedContainerIds);
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public void testWarWithContextXmlFile() throws Exception {
        File artifactDir = new File(this.getTestData().targetDir).getParentFile();
        Copy copyTask = (Copy)new AntUtils().createProject().createTask("copy");
        copyTask.setTofile(new File(artifactDir, "tomcat-context.war"));
        copyTask.setFile(new File(this.getTestData().getTestDataFileFor("tomcatcontext-war")));
        copyTask.execute();
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), new File(artifactDir, "tomcat-context.war").getPath(), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/tomcat-context/");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"tomcat context war not started", (String)"Test value is [test value]", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"tomcat context war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }

    public void testExpandedWarWithContextXmlFile() throws Exception {
        File artifactDir = new File(this.getTestData().targetDir).getParentFile();
        Expand expandTask = (Expand)new AntUtils().createProject().createTask("unwar");
        expandTask.setDest(new File(artifactDir, "tomcat-context"));
        expandTask.setSrc(new File(this.getTestData().getTestDataFileFor("tomcatcontext-war")));
        expandTask.execute();
        Deployable war = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), new File(artifactDir, "tomcat-context").getPath(), DeployableType.WAR);
        this.getLocalContainer().getConfiguration().addDeployable(war);
        URL warPingURL = new URL("http://localhost:" + this.getTestData().port + "/tomcat-context/");
        this.getLocalContainer().start();
        PingUtils.assertPingTrue((String)"tomcat context war not started", (String)"Test value is [test value]", (URL)warPingURL, (Logger)this.getLogger());
        this.getLocalContainer().stop();
        PingUtils.assertPingFalse((String)"tomcat context war not stopped", (URL)warPingURL, (Logger)this.getLogger());
    }
}

