/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java;

import java.net.URL;
import java.util.Map;
import junit.framework.Assert;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.log.Logger;

public class PingUtils
extends Assert {
    private static final int TIMEOUT = 20000;

    public static void assertPing(String message, String expectedContent, URL pingURL, Map<String, String> requestProperties, boolean expectTrue, Logger errorLogger) {
        HttpUtils httpUtils = new HttpUtils();
        httpUtils.setLogger(errorLogger);
        HttpUtils.HttpResult result = new HttpUtils.HttpResult();
        boolean success = false;
        success = expectTrue ? PingUtils.pingSuccessWithTimeout(httpUtils, pingURL, requestProperties, result) : httpUtils.ping(pingURL, requestProperties, result, 20000L);
        StringBuilder text = new StringBuilder(message);
        text.append(". Failed to ping [" + pingURL.toString() + "], ");
        if (requestProperties != null && !requestProperties.isEmpty()) {
            text.append("requestProperties = " + requestProperties + ", ");
        }
        if (result.responseCode == -1) {
            text.append("Cannot connect to the URL");
        } else {
            text.append("Reason = [" + result.responseMessage + "], Body = [" + result.responseBody + "], Code = [" + result.responseCode + "]");
        }
        if (expectTrue) {
            PingUtils.assertTrue((String)text.toString(), (boolean)success);
        } else {
            PingUtils.assertFalse((String)text.toString(), (boolean)success);
        }
        if (expectedContent != null) {
            String content = result.responseBody;
            PingUtils.assertNotNull((String)"result.responseBody is null", (Object)content);
            PingUtils.assertTrue((String)(content + " does not contain " + expectedContent), (boolean)content.contains(expectedContent));
        }
    }

    private static boolean pingSuccessWithTimeout(HttpUtils httpUtils, URL pingUrl, Map<String, String> requestProperties, HttpUtils.HttpResult result) {
        boolean success = false;
        long timeout = System.currentTimeMillis() + 20000L;
        while (!(success = httpUtils.ping(pingUrl, requestProperties, result, 20000L))) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new CargoException("Cannot ping container", (Throwable)e);
            }
            if (System.currentTimeMillis() < timeout) continue;
        }
        return success;
    }

    public static void assertPingTrue(String message, String expectedContent, URL pingURL, Map<String, String> requestProperties, Logger errorLogger) {
        PingUtils.assertPing(message, expectedContent, pingURL, requestProperties, true, errorLogger);
    }

    public static void assertPingTrue(String message, String expectedContent, URL pingURL, Logger errorLogger) {
        PingUtils.assertPing(message, expectedContent, pingURL, null, true, errorLogger);
    }

    public static void assertPingFalse(String message, String expectedContent, URL pingURL, Logger errorLogger) {
        PingUtils.assertPing(message, expectedContent, pingURL, null, false, errorLogger);
    }

    public static void assertPingTrue(String message, URL pingURL, Logger errorLogger) {
        PingUtils.assertPingTrue(message, null, pingURL, errorLogger);
    }

    public static void assertPingFalse(String message, URL pingURL, Logger errorLogger) {
        PingUtils.assertPingFalse(message, null, pingURL, errorLogger);
    }
}

