/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.sample.java.jboss;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import junit.framework.Test;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.sample.java.CargoTestSuite;
import org.codehaus.cargo.sample.java.EnvironmentTestData;
import org.codehaus.cargo.sample.java.jboss.AbstractJBossCapabilityTestCase;
import org.codehaus.cargo.sample.java.validator.HasDeployableSupportValidator;
import org.codehaus.cargo.sample.java.validator.HasStandaloneConfigurationValidator;
import org.codehaus.cargo.sample.java.validator.IsInstalledLocalContainerValidator;
import org.codehaus.cargo.sample.java.validator.StartsWithContainerValidator;
import org.codehaus.cargo.sample.java.validator.Validator;

public class AopCapabilityContainerTest
extends AbstractJBossCapabilityTestCase {
    private static final String JBOSSAOP_ASPECTMANAGER_OBJECT_NAME = "jboss.aop:service=AspectManager";

    public AopCapabilityContainerTest(String testName, EnvironmentTestData testData) throws Exception {
        super(testName, testData);
    }

    public static Test suite() throws Exception {
        CargoTestSuite suite = new CargoTestSuite("Test that verifies that deployment of AOP archive work on local installed JBoss containers");
        suite.addTestSuite(AopCapabilityContainerTest.class, new Validator[]{new StartsWithContainerValidator(new String[]{"jboss"}), new HasDeployableSupportValidator(DeployableType.AOP), new IsInstalledLocalContainerValidator(), new HasStandaloneConfigurationValidator()});
        return suite;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setContainer(this.createContainer(this.createConfiguration(ConfigurationType.STANDALONE)));
    }

    public void testDeployAopStatically() throws Exception {
        Deployable aop = new DefaultDeployableFactory().createDeployable(this.getContainer().getId(), this.getTestData().getTestDataFileFor("simple-aop"), DeployableType.AOP);
        this.getLocalContainer().getConfiguration().addDeployable(aop);
        this.getLocalContainer().start();
        AopCapabilityContainerTest.assertEquals((Object)State.STARTED, (Object)this.getContainer().getState());
        MBeanServerConnection server = this.createMBeanServerConnection();
        ObjectName objectName = ObjectName.getInstance(JBOSSAOP_ASPECTMANAGER_OBJECT_NAME);
        String pointcuts = (String)server.invoke(objectName, "pointcuts", new Object[0], new String[0]);
        this.getLogger().debug("Registered aop pointcuts: " + pointcuts, ((Object)((Object)this)).getClass().getName());
        AopCapabilityContainerTest.assertTrue((String)"Dummy cargo aop pointcut not found", (boolean)pointcuts.contains("cargoTestDataSimpleAop"));
        this.getLocalContainer().stop();
    }
}

