/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.squid.check;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.squid.check.SquidCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceFile;

@Rule(key="NoSonar", priority=Priority.INFO)
public class NoSonarCheck
extends SquidCheck {
    public void visitFile(SourceFile sourceFile) {
        for (Integer line : sourceFile.getNoSonarTagLines()) {
            CheckMessage message = new CheckMessage((CodeCheck)this, "Is //NOSONAR used to exclude false-positive or to hide real quality flaw ?", new Object[0]);
            message.setBypassExclusion(true);
            message.setLine(line.intValue());
            sourceFile.log(message);
        }
    }
}

