/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.check;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.check.BytecodeCheck;
import org.sonar.java.bytecode.check.SerializableContract;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

@Rule(key="UnusedProtectedMethod", priority=Priority.MAJOR)
public class UnusedProtectedMethodCheck
extends BytecodeCheck {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (!(asmMethod.isUsed() || !asmMethod.isProtected() || this.asmClass.isAbstract() || SerializableContract.methodMatch(asmMethod) || asmMethod.isInherited())) {
            CheckMessage message = new CheckMessage((CodeCheck)this, "Protected method '" + asmMethod.getName() + "(...)' is never used.", new Object[0]);
            SourceMethod sourceMethod = this.getSourceMethod(asmMethod);
            if (sourceMethod != null) {
                message.setLine(sourceMethod.getStartAtLine());
            }
            SourceFile file = this.getSourceFile(this.asmClass);
            file.log(message);
        }
    }
}

