/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.api.SourceCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstUtils {
    private AstUtils() {
    }

    public static AST findType(DetailAST ast) {
        DetailAST typeAst = ast.findFirstToken(13);
        if (typeAst != null) {
            return typeAst.getFirstChild();
        }
        return null;
    }

    public static boolean isClassVariable(DetailAST ast) {
        return ast.getType() == 10 && ast.getParent().getType() == 6 && AstUtils.isClass(ast.getParent().getParent());
    }

    public static boolean isClass(DetailAST ast) {
        return ast.getType() == 14 || ast.getType() == 154 || ast.getType() == 157 || ast.getType() == 15;
    }

    public static boolean isInterfaceVariable(DetailAST ast) {
        return ast.getType() == 10 && ast.getParent().getType() == 6 && AstUtils.isInterface(ast.getParent().getParent());
    }

    public static boolean isInterface(DetailAST ast) {
        return ast.getType() == 15;
    }

    public static boolean isFinal(DetailAST detailAst) {
        return AstUtils.isModifier(detailAst, 39);
    }

    public static boolean isStatic(DetailAST detailAst) {
        return AstUtils.isModifier(detailAst, 64);
    }

    public static boolean isModifier(DetailAST detailAst, int modifierType) {
        DetailAST modifiers = detailAst.findFirstToken(5);
        if (modifiers != null) {
            boolean isModifierMatching = modifiers.branchContains(modifierType);
            if (!isModifierMatching && AstUtils.isInterfaceVariable(detailAst)) {
                return modifierType == 64 || modifierType == 39;
            }
            return isModifierMatching;
        }
        return false;
    }

    public static Scope getScope(DetailAST ast) {
        Scope found;
        DetailAST modifierAst = ast.findFirstToken(5);
        Scope scope = found = modifierAst != null ? ScopeUtils.getScopeFromMods((DetailAST)modifierAst) : Scope.NOTHING;
        if (found.compareTo((Enum)Scope.PACKAGE) == 0 && (ast.getType() == 9 || ast.getType() == 10)) {
            found = AstUtils.isScope(Scope.PACKAGE, found) && AstUtils.findParent(ast, 15) != null ? Scope.PUBLIC : found;
        }
        return found;
    }

    public static boolean isScope(Scope toCompare, Scope scope) {
        return scope.compareTo((Enum)toCompare) == 0;
    }

    public static boolean isType(DetailAST ast, int type) {
        return ast.getType() == type;
    }

    public static DetailAST findParent(DetailAST ast, int tokenType) {
        DetailAST parent = ast.getParent();
        if (parent != null) {
            return parent.getType() == tokenType ? parent : AstUtils.findParent(parent, tokenType);
        }
        return null;
    }

    public static void ensureResourceType(SourceCode resource, Class<? extends SourceCode> resourceType) {
        if (!resource.isType(resourceType)) {
            throw new AnalysisException("Resource " + resource.getKey() + " must be of type " + resourceType.getName());
        }
    }
}

