/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassworldsClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ClassworldsClassLoader.class);

    private ClassworldsClassLoader() {
    }

    public static ClassLoader create(File bytecodeFileOrDirectory) {
        return ClassworldsClassLoader.create(Arrays.asList(bytecodeFileOrDirectory));
    }

    public static ClassLoader create(Collection<File> bytecodeFilesOrDirectories) {
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm realm = world.newRealm("squid.project", null);
            for (File bytecode : bytecodeFilesOrDirectories) {
                URL url = ClassworldsClassLoader.getURL(bytecode);
                if (bytecode.isFile() && url.toString().endsWith(".class")) {
                    LOG.info("Sonar Squid ClassLoader was expecting a JAR file instead of CLASS file : '" + bytecode.getAbsolutePath() + "'");
                    continue;
                }
                realm.addConstituent(url);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("----- Classpath analyzed by Squid:");
                for (URL url : realm.getConstituents()) {
                    LOG.debug(url.toString());
                }
                LOG.debug("-----");
            }
            return realm.getClassLoader();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create classloader", e);
        }
    }

    private static URL getURL(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (file.isDirectory() && !url.toString().endsWith("/")) {
            url = new URL(url.toString() + "/");
        }
        return url;
    }
}

