/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.java.ast.CheckstyleAuditListener;
import org.sonar.java.ast.CheckstyleSquidBridge;
import org.sonar.java.ast.visitor.AccessorVisitor;
import org.sonar.java.ast.visitor.AnonymousInnerClassVisitor;
import org.sonar.java.ast.visitor.BlankLinesVisitor;
import org.sonar.java.ast.visitor.BranchVisitor;
import org.sonar.java.ast.visitor.ClassVisitor;
import org.sonar.java.ast.visitor.CommentVisitor;
import org.sonar.java.ast.visitor.ComplexityVisitor;
import org.sonar.java.ast.visitor.EndAtLineVisitor;
import org.sonar.java.ast.visitor.FileVisitor;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.java.ast.visitor.LinesOfCodeVisitor;
import org.sonar.java.ast.visitor.LinesVisitor;
import org.sonar.java.ast.visitor.MethodVisitor;
import org.sonar.java.ast.visitor.PackageVisitor;
import org.sonar.java.ast.visitor.PublicApiVisitor;
import org.sonar.java.ast.visitor.StatementVisitor;
import org.sonar.java.squid.JavaSquidConfiguration;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceCode;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAstScanner
extends CodeScanner<JavaAstVisitor> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaAstScanner.class);
    private JavaSquidConfiguration conf;
    private SourceCode project;

    public JavaAstScanner(JavaSquidConfiguration conf, SourceCode project) {
        this.conf = conf;
        this.project = project;
    }

    private Checker createChecker(Charset charset) {
        Checker checker;
        InputStream checkstyleConfig = null;
        try {
            checkstyleConfig = JavaAstScanner.class.getClassLoader().getResourceAsStream("checkstyle-configuration.xml");
            String readenConfig = IOUtils.toString((InputStream)checkstyleConfig);
            readenConfig = readenConfig.replace("${charset}", charset.toString());
            checkstyleConfig = new ByteArrayInputStream(readenConfig.getBytes());
            Configuration config = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(checkstyleConfig), (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
            Checker c = new Checker();
            ClassLoader moduleClassLoader = Checker.class.getClassLoader();
            c.setModuleClassLoader(moduleClassLoader);
            c.configure(config);
            c.addListener((AuditListener)new CheckstyleAuditListener());
            checker = c;
        }
        catch (Exception e) {
            try {
                throw new AnalysisException("Unable to create Checkstyle Checker object with 'checkstyle-configuration.xml' as Checkstyle configuration file name", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(checkstyleConfig);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)checkstyleConfig);
        return checker;
    }

    public JavaAstScanner scanDirectory(File javaSourceDirectory) {
        ArrayList inputFiles = Lists.newArrayList();
        Collection files = FileUtils.listFiles((File)javaSourceDirectory, (IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.directoryFileFilter());
        for (File file : files) {
            inputFiles.add(InputFileUtils.create((File)javaSourceDirectory, (File)file));
        }
        return this.scanFiles(inputFiles);
    }

    public JavaAstScanner scanFile(InputFile javaFile) {
        return this.scanFiles(Arrays.asList(javaFile));
    }

    public JavaAstScanner scanFiles(Collection<InputFile> inputFiles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("----- Java sources analyzed by Squid:");
            for (InputFile inputFile : inputFiles) {
                LOG.debug(inputFile.toString());
            }
            LOG.debug("-----");
        }
        Stack<SourceCode> resourcesStack = new Stack<SourceCode>();
        resourcesStack.add(this.project);
        for (JavaAstVisitor visitor : this.getVisitors()) {
            visitor.setSourceCodeStack(resourcesStack);
        }
        CheckstyleSquidBridge.setASTVisitors(this.getVisitors());
        CheckstyleSquidBridge.setSquidConfiguration(this.conf);
        CheckstyleSquidBridge.setInputFiles(inputFiles);
        this.launchCheckstyle(InputFileUtils.toFiles(inputFiles), this.conf.getCharset());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchCheckstyle(Collection<File> files, Charset charset) {
        Checker c = this.createChecker(charset);
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            c.setClassloader(((Object)((Object)this)).getClass().getClassLoader());
            c.setModuleClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            c.process((List)Lists.newArrayList(files));
            c.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(initialClassLoader);
        }
    }

    public Collection<Class<? extends JavaAstVisitor>> getVisitorClasses() {
        ArrayList visitorClasses = Lists.newArrayList();
        visitorClasses.add(PackageVisitor.class);
        visitorClasses.add(FileVisitor.class);
        visitorClasses.add(ClassVisitor.class);
        visitorClasses.add(AnonymousInnerClassVisitor.class);
        visitorClasses.add(MethodVisitor.class);
        visitorClasses.add(EndAtLineVisitor.class);
        visitorClasses.add(LinesVisitor.class);
        visitorClasses.add(BlankLinesVisitor.class);
        visitorClasses.add(CommentVisitor.class);
        visitorClasses.add(PublicApiVisitor.class);
        visitorClasses.add(BranchVisitor.class);
        visitorClasses.add(StatementVisitor.class);
        if (this.conf.isAnalysePropertyAccessors()) {
            visitorClasses.add(AccessorVisitor.class);
        }
        visitorClasses.add(ComplexityVisitor.class);
        visitorClasses.add(LinesOfCodeVisitor.class);
        return visitorClasses;
    }

    public void accept(CodeVisitor visitor) {
        if (visitor instanceof JavaAstVisitor) {
            super.accept(visitor);
        }
    }
}

