/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitor.AstUtils;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="AvoidBreakOutsideSwitch", priority=Priority.MAJOR)
public class BreakCheck
extends JavaAstVisitor {
    private static final List<Integer> WANTED_TOKENS = Arrays.asList(86);

    @Override
    public List<Integer> getWantedTokens() {
        return WANTED_TOKENS;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (AstUtils.findParent(ast, 89) == null) {
            CheckMessage message = new CheckMessage((Object)this, "The 'break' branching statement prevents refactoring the source code to reduce the complexity.", new Object[0]);
            message.setLine(ast.getLineNo());
            SourceFile sourceFile = (SourceFile)this.peekSourceCode().getParent(SourceFile.class);
            sourceFile.log(message);
        }
    }
}

