/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentVisitor
extends JavaAstVisitor {
    private static final List<Integer> WANTED_TOKENS = Arrays.asList(73);

    @Override
    public List<Integer> getWantedTokens() {
        return WANTED_TOKENS;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int startAtLine = this.peekSourceCode().getStartAtLine();
        int endAtLine = this.peekSourceCode().getEndAtLine();
        int commentedOutCodeLines = this.getSource().getMeasure(Metric.COMMENTED_OUT_CODE_LINES, startAtLine, endAtLine);
        int commentLines = this.getSource().getMeasure(Metric.COMMENT_LINES, startAtLine, endAtLine);
        this.peekSourceCode().setMeasure((MetricDef)Metric.COMMENTED_OUT_CODE_LINES, commentedOutCodeLines);
        this.peekSourceCode().setMeasure((MetricDef)Metric.COMMENT_LINES, commentLines + commentedOutCodeLines);
        this.peekSourceCode().setMeasure((MetricDef)Metric.COMMENT_BLANK_LINES, this.getSource().getMeasure(Metric.COMMENT_BLANK_LINES, startAtLine, endAtLine));
    }

    @Override
    public void visitFile(DetailAST ast) {
        SourceFile file = (SourceFile)this.peekSourceCode();
        file.addNoSonarTagLines(this.getSource().getNoSonarTagLines());
        file.setMeasure((MetricDef)Metric.HEADER_COMMENT_LINES, this.getSource().getMeasure(Metric.HEADER_COMMENT_LINES));
        int commentedOutCodeLines = this.getSource().getMeasure(Metric.COMMENTED_OUT_CODE_LINES);
        int commentLines = this.getSource().getMeasure(Metric.COMMENT_LINES);
        file.setMeasure((MetricDef)Metric.COMMENTED_OUT_CODE_LINES, commentedOutCodeLines);
        file.setMeasure((MetricDef)Metric.COMMENT_LINES, commentLines + commentedOutCodeLines);
        file.setMeasure((MetricDef)Metric.COMMENT_BLANK_LINES, this.getSource().getMeasure(Metric.COMMENT_BLANK_LINES));
    }
}

