/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.check;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;

@Rule(key="CallToDeprecatedMethod", priority=Priority.MINOR)
public class CallToDeprecatedMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitEdge(AsmEdge edge) {
        if (edge.getTo().isDeprecated() && edge.getTo() instanceof AsmMethod) {
            AsmMethod targetMethod = (AsmMethod)edge.getTo();
            SourceFile sourceFile = this.getSourceFile(this.asmClass);
            CheckMessage message = new CheckMessage((Object)this, "Method '" + targetMethod.getName() + "(...)' is deprecated.", new Object[0]);
            message.setLine(edge.getSourceLineNumber());
            sourceFile.log(message);
        }
    }
}

