/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.sonar.java.bytecode.loader.FileSystemLoader;
import org.sonar.java.bytecode.loader.JarLoader;
import org.sonar.java.bytecode.loader.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquidClassLoader
extends ClassLoader
implements Closeable {
    private final List<Loader> loaders = new ArrayList<Loader>();

    public SquidClassLoader(Collection<File> files) throws IOException {
        super(null);
        for (File file : files) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                this.loaders.add(new FileSystemLoader(file));
                continue;
            }
            this.loaders.add(new JarLoader(file));
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.loadClassBytes(name);
        if (classBytes == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    private byte[] loadClassBytes(String name) {
        String resourceName = name.replace('.', '/') + ".class";
        for (Loader loader : this.loaders) {
            byte[] classBytes = loader.loadBytes(resourceName);
            if (classBytes == null) continue;
            return classBytes;
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        for (Loader loader : this.loaders) {
            URL url = loader.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Loader loader : this.loaders) {
            URL url = loader.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Iterators.asEnumeration(result.iterator());
    }

    @Override
    public void close() {
        for (Loader loader : this.loaders) {
            loader.close();
        }
    }
}

