/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.squid.check;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.squid.check.SquidCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;

@Rule(key="ClassCyclomaticComplexity", priority=Priority.MAJOR)
public class ClassComplexityCheck
extends SquidCheck {
    public static final int DEFAULT_MAX = 200;
    @RuleProperty(defaultValue="200")
    private Integer max = 200;

    public void visitClass(SourceClass sourceClass) {
        int complexity = sourceClass.getInt(Metric.COMPLEXITY);
        if (complexity > this.max) {
            CheckMessage message = new CheckMessage((Object)this, "The Cyclomatic Complexity of this class is " + complexity + " which is greater than " + this.max + " authorized.", new Object[0]);
            message.setLine(sourceClass.getStartAtLine());
            message.setCost((double)(complexity - this.max));
            ((SourceFile)sourceClass.getParent(SourceFile.class)).log(message);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

