/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.batch.ResourceCreationLock;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.squid.SquidExecutor;
import org.sonar.plugins.squid.SquidRuleRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Phase(name=Phase.Name.PRE)
@DependsUpon(value={"BEFORE_SQUID"})
@DependedUpon(value={"squid"})
public class SquidSensor
implements Sensor {
    private NoSonarFilter noSonarFilter;
    private RulesProfile profile;
    private ProjectClasspath projectClasspath;
    private ResourceCreationLock lock;

    public SquidSensor(RulesProfile profile, NoSonarFilter noSonarFilter, ProjectClasspath projectClasspath, ResourceCreationLock lock) {
        this.noSonarFilter = noSonarFilter;
        this.profile = profile;
        this.projectClasspath = projectClasspath;
        this.lock = lock;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "java".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        this.analyzeMainSources(project, context);
        this.browseTestSources(project, context);
        this.lock.lock();
    }

    private void analyzeMainSources(Project project, SensorContext context) {
        boolean analyzePropertyAccessors = project.getConfiguration().getBoolean("sonar.squid.analyse.property.accessors", true);
        String fieldNamesToExcludeFromLcom4Computation = project.getConfiguration().getString("sonar.squid.fieldsToExcludeFromLcom4Computation", "LOG, logger");
        Charset charset = project.getFileSystem().getSourceCharset();
        AnnotationCheckFactory factory = AnnotationCheckFactory.create((RulesProfile)this.profile, (String)"squid", SquidRuleRepository.getCheckClasses());
        SquidExecutor squidExecutor = new SquidExecutor(analyzePropertyAccessors, fieldNamesToExcludeFromLcom4Computation, (CheckFactory)factory, charset);
        squidExecutor.scan(this.getMainSourceFiles(project), this.getBytecodeFiles(project));
        squidExecutor.save(project, context, this.noSonarFilter);
        squidExecutor.flush();
    }

    private void browseTestSources(Project project, SensorContext context) {
        for (InputFile testFile : project.getFileSystem().testFiles(new String[]{"java"})) {
            context.index((Resource)JavaFile.fromRelativePath((String)testFile.getRelativePath(), (boolean)true));
        }
    }

    private List<InputFile> getMainSourceFiles(Project project) {
        return project.getFileSystem().mainFiles(new String[]{"java"});
    }

    protected Collection<File> getBytecodeFiles(Project project) {
        if (project.getConfiguration().getBoolean("sonar.skipDesign", false)) {
            return Collections.emptyList();
        }
        return this.projectClasspath.getElements();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

