/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.plugins.squid.bridges.ChecksBridge;
import org.sonar.plugins.squid.bridges.ChidamberKemererBridge;
import org.sonar.plugins.squid.bridges.CopyBasicMeasuresBridge;
import org.sonar.plugins.squid.bridges.DesignBridge;
import org.sonar.plugins.squid.bridges.Lcom4BlocksBridge;
import org.sonar.plugins.squid.bridges.NoSonarFilterLoader;
import org.sonar.plugins.squid.bridges.PackagesBridge;
import org.sonar.plugins.squid.bridges.PublicUndocumentedApiBridge;
import org.sonar.plugins.squid.bridges.ResourceIndex;
import org.sonar.plugins.squid.bridges.RobertCMartinBridge;
import org.sonar.squid.Squid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BridgeFactory {
    private BridgeFactory() {
    }

    private static List<Bridge> create(NoSonarFilter noSonarFilter, boolean skipPackageDesignAnalysis) {
        ArrayList result = Lists.newArrayList((Object[])new Bridge[]{new CopyBasicMeasuresBridge(), new PackagesBridge(), new PublicUndocumentedApiBridge(), new NoSonarFilterLoader(noSonarFilter), new ChidamberKemererBridge(), new RobertCMartinBridge(), new Lcom4BlocksBridge(), new ChecksBridge()});
        if (!skipPackageDesignAnalysis) {
            result.add(new DesignBridge());
        }
        return result;
    }

    public static List<Bridge> create(boolean bytecodeScanned, boolean skipPackageDesignAnalysis, SensorContext context, CheckFactory checkFactory, ResourceIndex resourceIndex, Squid squid, NoSonarFilter noSonarFilter) {
        ArrayList<Bridge> result = new ArrayList<Bridge>();
        for (Bridge bridge : BridgeFactory.create(noSonarFilter, skipPackageDesignAnalysis)) {
            bridge.setCheckFactory(checkFactory);
            if (bridge.needsBytecode() && !bytecodeScanned) continue;
            bridge.setContext(context);
            bridge.setSquid(squid);
            bridge.setResourceIndex(resourceIndex);
            result.add(bridge);
        }
        return result;
    }
}

