/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.InputFile;
import org.sonar.java.ast.CheckstyleSquidBridgeContext;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.squid.text.Source;

public class CheckstyleSquidBridge
extends Check {
    private static Logger logger = LoggerFactory.getLogger(CheckstyleSquidBridge.class);
    private static CheckstyleSquidBridgeContext bridgeContext;

    static void setContext(CheckstyleSquidBridgeContext context) {
        bridgeContext = context;
    }

    public int[] getDefaultTokens() {
        return bridgeContext.getAllTokens();
    }

    public void beginTree(DetailAST ast) {
        try {
            String filename = this.getFileContents().getFilename();
            Source source = this.createSource();
            InputFile inputFile = bridgeContext.getInputFile(new File(filename));
            for (JavaAstVisitor visitor : bridgeContext.getVisitors()) {
                visitor.setFileContents(this.getFileContents());
                visitor.setSource(source);
                visitor.setInputFile(inputFile);
                visitor.visitFile(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    private Source createSource() {
        return new Source(this.getFileContents().getLines(), bridgeContext.getCodeRecognizer());
    }

    public void visitToken(DetailAST ast) {
        try {
            for (JavaAstVisitor visitor : bridgeContext.getVisitors()) {
                if (!visitor.getWantedTokens().contains(ast.getType())) continue;
                visitor.visitToken(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    public void leaveToken(DetailAST ast) {
        JavaAstVisitor[] visitors = bridgeContext.getVisitors();
        try {
            for (int i = visitors.length - 1; i >= 0; --i) {
                JavaAstVisitor visitor = visitors[i];
                if (!visitor.getWantedTokens().contains(ast.getType())) continue;
                visitor.leaveToken(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    public void finishTree(DetailAST ast) {
        JavaAstVisitor[] visitors = bridgeContext.getVisitors();
        try {
            for (int i = visitors.length - 1; i >= 0; --i) {
                JavaAstVisitor visitor = visitors[i];
                visitor.leaveFile(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    private void logAndThrowException(RuntimeException e) {
        logger.error("Squid Error occurs when analysing :" + this.getFileContents().getFilename(), (Throwable)e);
        throw e;
    }
}

