/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.PatternUtils;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.java.ast.visitor.PublicApiVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="UndocumentedApi", priority=Priority.MAJOR)
public class UndocumentedApiCheck
extends JavaAstVisitor {
    @RuleProperty
    private String forClasses = "";
    private WildcardPattern[] patterns;

    @Override
    public List<Integer> getWantedTokens() {
        return PublicApiVisitor.TOKENS;
    }

    @Override
    public void visitToken(DetailAST ast) {
        SourceCode currentResource = this.peekSourceCode();
        SourceClass sourceClass = this.peekParentClass();
        if (WildcardPattern.match((WildcardPattern[])this.getPatterns(), (String)sourceClass.getKey())) {
            if (currentResource instanceof SourceMethod && ((SourceMethod)currentResource).isAccessor()) {
                return;
            }
            if (PublicApiVisitor.isPublicApi(ast) && !PublicApiVisitor.isDocumentedApi(ast, this.getFileContents())) {
                SourceFile sourceFile = (SourceFile)currentResource.getParent(SourceFile.class);
                CheckMessage message = new CheckMessage((Object)this, "Avoid undocumented API.", new Object[0]);
                message.setLine(ast.getLineNo());
                sourceFile.log(message);
            }
        }
    }

    private WildcardPattern[] getPatterns() {
        if (this.patterns == null) {
            this.patterns = PatternUtils.createPatterns(StringUtils.defaultIfEmpty((String)this.forClasses, (String)"**"));
        }
        return this.patterns;
    }

    public String getForClasses() {
        return this.forClasses;
    }

    public void setForClasses(String forClasses) {
        this.forClasses = forClasses;
    }
}

