/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="AvoidContinueStatement", priority=Priority.MAJOR)
public class ContinueCheck
extends JavaAstVisitor {
    private static final List<Integer> WANTED_TOKENS = Arrays.asList(87);

    @Override
    public List<Integer> getWantedTokens() {
        return WANTED_TOKENS;
    }

    @Override
    public void visitToken(DetailAST ast) {
        SourceCode currentResource = this.peekSourceCode();
        CheckMessage message = new CheckMessage((Object)this, "The 'continue' branching statement prevent refactoring the source code to reduce the complexity.", new Object[0]);
        message.setLine(ast.getLineNo());
        SourceFile sourceFile = (SourceFile)currentResource.getParent(SourceFile.class);
        sourceFile.log(message);
    }
}

