/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.java.api.JavaClass;
import org.sonar.java.api.JavaMethod;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.bytecode.BytecodeScanner;
import org.sonar.java.squid.JavaSquidConfiguration;
import org.sonar.java.squid.SquidScanner;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.plugins.squid.bridges.BridgeFactory;
import org.sonar.plugins.squid.bridges.ResourceIndex;
import org.sonar.squid.Squid;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.api.SquidConfiguration;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SquidExecutor {
    private Squid squid;
    private boolean sourceScanned = false;
    private boolean bytecodeScanned = false;
    private CheckFactory checkFactory;

    public SquidExecutor(boolean analyzePropertyAccessors, String fieldNamesToExcludeFromLcom4Computation, CheckFactory checkFactory, Charset sourcesCharset) {
        JavaSquidConfiguration conf = this.createJavaSquidConfiguration(analyzePropertyAccessors, fieldNamesToExcludeFromLcom4Computation, sourcesCharset);
        this.squid = new Squid((SquidConfiguration)conf);
        this.checkFactory = checkFactory;
    }

    private JavaSquidConfiguration createJavaSquidConfiguration(boolean analyzePropertyAccessors, String fieldNamesToExcludeFromLcom4Computation, Charset sourcesCharset) {
        JavaSquidConfiguration conf = new JavaSquidConfiguration(analyzePropertyAccessors, sourcesCharset);
        if (!StringUtils.isBlank((String)fieldNamesToExcludeFromLcom4Computation)) {
            for (String fieldName : fieldNamesToExcludeFromLcom4Computation.split(",")) {
                if (StringUtils.isBlank((String)fieldName)) continue;
                conf.addFieldToExcludeFromLcom4Calculation(fieldName);
            }
        }
        return conf;
    }

    public void scan(Collection<InputFile> sourceFiles, Collection<File> bytecodeFilesOrDirectories) {
        for (Object checker : this.checkFactory.getChecks()) {
            this.squid.registerVisitor((CodeVisitor)checker);
        }
        this.scanSources(sourceFiles);
        if (this.sourceScanned) {
            this.scanBytecode(bytecodeFilesOrDirectories);
        }
        this.squid.decorateSourceCodeTreeWith((MetricDef[])Metric.values());
        this.scanSquidIndex();
    }

    public void save(Project project, SensorContext context, NoSonarFilter noSonarFilter) {
        if (this.sourceScanned) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Squid extraction");
            ResourceIndex resourceIndex = new ResourceIndex().loadSquidResources(this.squid, context, project);
            boolean skipPackageDesignAnalysis = false;
            if (project.getConfiguration() != null) {
                skipPackageDesignAnalysis = project.getConfiguration().getBoolean("sonar.skipPackageDesign", false);
            }
            List<Bridge> bridges = BridgeFactory.create(this.bytecodeScanned, skipPackageDesignAnalysis, context, this.checkFactory, resourceIndex, this.squid, noSonarFilter);
            this.saveProject(resourceIndex, bridges);
            this.savePackages(resourceIndex, bridges);
            this.saveFiles(resourceIndex, bridges);
            this.saveClasses(resourceIndex, bridges);
            this.saveMethods(resourceIndex, bridges);
            profiler.stop();
        }
    }

    private void saveProject(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Resource sonarResource = (Resource)resourceIndex.get(this.squid.getProject());
        for (Bridge bridge : bridges) {
            bridge.onProject(this.squid.getProject(), (Project)sonarResource);
        }
    }

    private void savePackages(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection packages = this.squid.search(new Query[]{new QueryByType(SourcePackage.class)});
        for (SourceCode squidPackage : packages) {
            Resource sonarPackage = (Resource)resourceIndex.get(squidPackage);
            for (Bridge bridge : bridges) {
                bridge.onPackage((SourcePackage)squidPackage, sonarPackage);
            }
        }
    }

    private void saveFiles(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidFiles = this.squid.search(new Query[]{new QueryByType(SourceFile.class)});
        for (SourceCode squidFile : squidFiles) {
            Resource sonarFile = (Resource)resourceIndex.get(squidFile);
            for (Bridge bridge : bridges) {
                bridge.onFile((SourceFile)squidFile, sonarFile);
            }
        }
    }

    private void saveClasses(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidClasses = this.squid.search(new Query[]{new QueryByType(SourceClass.class)});
        for (SourceCode squidClass : squidClasses) {
            Resource sonarClass = (Resource)resourceIndex.get(squidClass);
            if (sonarClass == null) continue;
            for (Bridge bridge : bridges) {
                bridge.onClass((SourceClass)squidClass, (JavaClass)sonarClass);
            }
        }
    }

    private void saveMethods(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidMethods = this.squid.search(new Query[]{new QueryByType(SourceMethod.class)});
        for (SourceCode squidMethod : squidMethods) {
            JavaMethod sonarMethod = (JavaMethod)resourceIndex.get(squidMethod);
            if (sonarMethod == null) continue;
            for (Bridge bridge : bridges) {
                bridge.onMethod((SourceMethod)squidMethod, sonarMethod);
            }
        }
    }

    void scanSources(Collection<InputFile> sourceFiles) {
        if (sourceFiles != null && !sourceFiles.isEmpty()) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java AST scan");
            JavaAstScanner sourceScanner = (JavaAstScanner)this.squid.register(JavaAstScanner.class);
            sourceScanner.scanFiles(sourceFiles);
            this.sourceScanned = true;
            profiler.stop();
        } else {
            this.sourceScanned = false;
        }
    }

    void scanBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (SquidExecutor.hasBytecode(bytecodeFilesOrDirectories)) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java bytecode scan");
            BytecodeScanner bytecodeScanner = (BytecodeScanner)this.squid.register(BytecodeScanner.class);
            bytecodeScanner.scan(bytecodeFilesOrDirectories);
            this.bytecodeScanned = true;
            profiler.stop();
        } else {
            this.bytecodeScanned = false;
        }
    }

    static boolean hasBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (bytecodeFilesOrDirectories == null) {
            return false;
        }
        for (File bytecodeFilesOrDirectory : bytecodeFilesOrDirectories) {
            if (!bytecodeFilesOrDirectory.exists() || !bytecodeFilesOrDirectory.isFile() && FileUtils.listFiles((File)bytecodeFilesOrDirectory, (String[])new String[]{"class"}, (boolean)true).isEmpty()) continue;
            return true;
        }
        return false;
    }

    void scanSquidIndex() {
        TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java Squid scan");
        SquidScanner squidScanner = (SquidScanner)this.squid.register(SquidScanner.class);
        squidScanner.scan();
        profiler.stop();
    }

    boolean isSourceScanned() {
        return this.sourceScanned;
    }

    boolean isBytecodeScanned() {
        return this.bytecodeScanned;
    }

    void flush() {
        this.squid.flush();
    }

    public Squid getSquid() {
        return this.squid;
    }
}

